#include "Step_Motor.h"
#include "mbed.h"
#include "def.h"
 
stepmotor::stepmotor(PinName in1, PinName in2, PinName in3, PinName in4, PinName in5,PinName in6, PinName in7, PinName in8) : motor_out(in1,in2,in3,in4,in5,in6,in7,in8) {  
 
    motor_out=0x0;
    nstep=0;
    nstep2=0;
    motorSpeed=1100;
    mot2=0;
}
Serial pc1(USBTX,USBRX);
 
void stepmotor::move() { 
   switch(nstep2)
        { 
            case 0: mot2 = 0x1; break;  // 0001
            case 1: mot2 = 0x3; break;  // 0011
            case 2: mot2 = 0x2; break;  // 0010   
            case 3: mot2 = 0x6; break;  // 0110
            case 4: mot2 = 0x4; break;  // 0100
            case 5: mot2 = 0xC; break;  // 1100
            case 6: mot2 = 0x8; break;  // 1000
            case 7: mot2 = 0x9; break;  // 1001
            
            default: mot2 = 0x0; break; // 0000
        }
        
   switch(nstep)
        { 
            case 0: motor_out = 0x10 + mot2; break;  // 0001 xxxx
            case 1: motor_out = 0x30 + mot2; break;  // 0011 xxxx
            case 2: motor_out = 0x20 + mot2; break;  // 0010 xxxx  
            case 3: motor_out = 0x60 + mot2; break;  // 0110 xxxx
            case 4: motor_out = 0x40 + mot2; break;  // 0100 xxxx
            case 5: motor_out = 0xC0 + mot2; break;  // 1100 xxxx
            case 6: motor_out = 0x80 + mot2; break;  // 1000 xxxx
            case 7: motor_out = 0x90 + mot2; break;  // 1001 xxxx
            
            default: motor_out = 0x00 + mot2; break; // 0000 xxxx
        }
        
        wait_us(motorSpeed);
        
}
 
void stepmotor::set_speed(int speed){
    motorSpeed=speed; //set motor speed us 
}
uint32_t stepmotor::get_speed(){
    return motorSpeed; // 
}
 
void stepmotor::step(uint32_t num_steps, uint8_t cw) {
//cw 0 si va a girar a la izquierda, 1 si gira a la derecha, 2 si sigue derecho, 3 retrocede      
    uint32_t count=num_steps ;
     pc1.baud(9600);              
pc1.format(8,SerialBase::None,1); 
    while(count){
        if (cw==LEFT)   {nstep++; nstep2++;}  
        if (cw==RIGHT)  {nstep--; nstep2--;}
        if (cw==FORWARD)   {nstep++;  nstep2--;}
        if (cw==BEHIND)   {nstep--;  nstep2++;}
        if (nstep>7) nstep=0;
        if (nstep<0) nstep=7;
        if (nstep2>7) nstep2=0;
        if (nstep2<0) nstep2=7;
        move();
        count--;
        
    }
    if (cw==LEFT)   {pc1.printf("LEFT \n");}  
    if (cw==RIGHT)  {pc1.printf("RIGHT \n");}
    if (cw==FORWARD)   {pc1.printf("DERE \n");}
    if (cw==BEHIND)   {pc1.printf("ATRAS \n");}
}
