#include "mbed.h"

extern Serial pc;
extern int frequ; //unit kHz
extern char dev_addr; //fixed

char get_half_byte(int *); //defined in I2C_read.cpp
char get_byte(int *); //defined in EasyFuse_Prog.cpp
void i2c_write_fn(I2C *, char , char );//defined in Easy Fuse Prog
char i2c_read_fn(I2C *, char ); //defined in Easy Fuse Prog
void read_bit(int ); // defined in I2C_hot_read

void i2c_hotread_fn(I2C *i2c_obj, char ptr, int bit_position) {
    int flag1;
    char temp;
    wait_us(10);
    (*i2c_obj).start();
    flag1 = (*i2c_obj).write(dev_addr); 
    if (flag1 != 1) pc.printf("\n\n\n\r\tNo Ack for dev addr :(");
    flag1 = (*i2c_obj).write(ptr);
    if (flag1 != 1) pc.printf("\n\n\r\tNo Ack reg pointer :(");
    (*i2c_obj).stop();
    wait_us(300);
    pc.printf("\n\n\n\r\tPress 's' to start hot read : ");    
    while(temp!='s') {
        temp = pc.getc();
    }
    //(*i2c_obj).start();
    //flag1 = (*i2c_obj).write(dev_addr | 0x01); //lsb 1 for read
    //if (flag1 != 1) pc.printf("\n\n\r\tNo Ack for dev addr :(");         
    read_bit(bit_position); // hot-read function
    (*i2c_obj).stop();    
}

void draw_sig_line() {
    pc.printf("\033[%dm ", 33);//change text color to yellow
    pc.printf("\n\n\n\n\r   \304");   
    for ( int i = 0; i<80; i++) pc.printf("\304");
    pc.printf("\033[%dm ", 32);//change text color to green
    pc.printf("\n\n\r");
} 

void get_new_val (char *reg_val06) {
    int flag1 = 0;
    pc.printf("\n\n\n\r\t\033[%dmChoose a Range trim from the above table (\033[%dmRecommended values are highlighted in red\033[%dm)",36,31,36);
    while (!flag1) {
        pc.printf("\n\n\r\tEnter new Range trim in hex (00 to ff): 0x");
        *reg_val06 = get_byte(&flag1);
        if ( *reg_val06 > 0x1F ) flag1 = 0; //Range trim is only 5 bits
        if (flag1 == 0) pc.printf(" \033[%dm Invalid Chracter!! No worries, let us try again \033[%dm",41,40);
    }
    pc.printf("\033[%dm",32);
}

void adc_meas (I2C *i2c_obj, char count, char lsb) {
    char adc_op;
    int voc;
    char temp;
    
    voc = lsb * count;
    
    temp = 0;
    pc.printf("\n\n\n\r\t\033[%dmSet Voc = %d mV (%d mV x %d). Press 'c' to continue: \033[%dm", 36, voc, lsb, count, 32);  
    while ( temp!='c') {
        temp = pc.getc();
    }
    i2c_write_fn(i2c_obj,0x14,count - 2); //Writing starting value in ADC
    wait_ms(5);                    
    i2c_write_fn(i2c_obj,0x0D,0x03); //tm_adc_en = tm_adc_go = 1; start conversion
    wait_ms(20); //to make sure conversion is complete
    adc_op = i2c_read_fn(i2c_obj,0x14);
    pc.printf("\n\n\n\r\t\033[%dmadc_op%d_%dmv = 0x%2.2X\033[%dm", 45, count, lsb, adc_op, 40);//displaying in Magenta background    
    return;         
}
    

void adc_test() {
    
    I2C i2c(p9,p10);
    char temp;
    char reg_val06;
    char reg_val06_max = 0x1F; //for debug, change to 0x1F    
    char reg_val05;
    char reg_val05_strt;
    char reg_val04;
    char reg_val07;  
    char adc_op31[32];
    char adc_op223[32];
    char d_adc_op192[32] = {0x00};
    char adc_op8 = 0x07;
    char adc_op8_old;
    char adc_op8_disp[32];    
    char d_adc_op = 0x00;
    char d_adc_op_old = 0x00;    
    int i = 0;
    int x = 0;
    
    i2c.frequency((frequ/2)*1000);
    LPC_PINCON->PINMODE_OD0 = (LPC_PINCON->PINMODE_OD0  | 0x0003); // To make p9 & P10 open_drain
    i2c.stop(); //add a stop after hot-read

    pc.printf("\033[%dm ", 31);//change text color to red    
    pc.printf("\n\n\n\r\tStarting adc test \n\r\t");
    for ( i = 0; i<18; i++) pc.printf("\334");  
    pc.printf("\n\n\r\033[%dm", 32);//change text color to blue        

    i2c_write_fn(&i2c,0x17,0x03); //dmux op = adc_conversion. DATA2_CLK will be high when adc conversion is ongoing       

    pc.printf("\033[%dm", 34);//change text color to blue
    pc.printf("\n\n\n\r\tConditions: \n\r\t");
    for ( i = 0; i<13; i++) pc.printf("\304");    
    pc.printf("\n\n\r\t  1. ASIC in test-mode "); 
    pc.printf("\n\n\r\t  2. Short input Rin (5ohms) resistor ");            
    pc.printf("\n\n\r\t  3. Please Monitor DATA2_CLK on oscilloscope. DATA2_CLK = 'adc_conversion'");
    pc.printf("\n\n\r\t  4. Positive input polarity");        
    pc.printf("\033[%dm ", 32);//change text color to green
    temp = 0;
    pc.printf("\n\n\n\r\t\033[%dmPress 'c' to continue: \033[%dm",36,32);  
    while ( temp!='c') {
        temp = pc.getc();
    }     
    i2c_write_fn(&i2c,0x0F,0x00); //Disabling Flyback
    
    //reg_val06 = i2c_read_fn(&i2c,0x06); //reading the initial range trim
    i2c_write_fn(&i2c,0x0D,0x01); //tm_adc_en = 1

    draw_sig_line();
    
    //*****************************************************************
    //******   ADC Range trim test
    //*****************************************************************
        
    pc.printf("\033[%dm ", 31);//change text color to red 
    pc.printf("\n\n\n\r\tStarting Range trim \n\r\t");  
    for ( i = 0; i<19; i++) pc.printf("\315");
    pc.printf("\033[%dm ", 32);//change text color to green     

    temp = 0;
    pc.printf("\n\n\n\r\t\033[%dmSet Voc = 63mV (2mV x 31.5). Press 'c' to continue: \033[%dm",36,32);  
    while ( temp!='c') {
        temp = pc.getc();
    } 
    //Making sure input polarity detector outputs are correct.
    i2c_write_fn(&i2c,0x10,0x10); //tm_PolComp_en = 1
    wait_ms(1);
    i2c_write_fn(&i2c,0x10,0x00); //tm_PolComp_en = 0
    pc.printf("\n\n\r\tFinding ADC outputs for all adc range with input = 63mV");    
    //Finding ADC outputs for all adc range with input = 63mV
    
    for ( reg_val06 = 0x00; reg_val06 <= reg_val06_max; reg_val06 = (reg_val06 + 1)) {
        
        i2c_write_fn(&i2c,0x06,reg_val06); 
        
        //Write initial value into ADC register
        if ( reg_val06 == 0x00 ) i2c_write_fn(&i2c,0x14,0x64); //starting value = 100. ADC reading will reduce as range trim increases
        else  i2c_write_fn(&i2c,0x14,adc_op31[(reg_val06 - 1)]); //starting with previous measurement value

        wait_ms(5);                    
        i2c_write_fn(&i2c,0x0D,0x03); //tm_adc_en = tm_adc_go = 1; start conversion
        wait_ms(20); //to make sure conversion is complete
        adc_op31[reg_val06] = i2c_read_fn(&i2c,0x14);
        pc.printf(".");        
    }                

    temp = 0;
    pc.printf("\n\n\n\r\t\033[%dmSet Voc = 447mV (2mV x 223.5). Press 'c' to continue: \033[%dm",36,32);  
    while ( temp!='c') {
        temp = pc.getc();
    } 
    pc.printf("\n\n\r\tFinding ADC outputs for all adc range with input = 447mV");       
    for ( reg_val06 = 0x00; reg_val06 <= reg_val06_max; reg_val06 = (reg_val06 + 1)) {
        
        i2c_write_fn(&i2c,0x06,reg_val06); 
        
        //Write initial value into ADC register
        if ( reg_val06 == 0x00 ) i2c_write_fn(&i2c,0x14,0x64); //starting value = 100. ADC reading will reduce as range trim increases
        else  i2c_write_fn(&i2c,0x14,adc_op223[(reg_val06 - 1)]); //starting with previous measurement value

        wait_ms(5);                    
        i2c_write_fn(&i2c,0x0D,0x03); //tm_adc_en = tm_adc_go = 1; start conversion
        wait_ms(20); //to make sure conversion is complete
        adc_op223[reg_val06] = i2c_read_fn(&i2c,0x14);
        d_adc_op192[reg_val06] = adc_op223[reg_val06] - adc_op31[reg_val06];
        pc.printf("."); 
    }
    //Printing results
    pc.printf("\n\n\n\r\t\332");
    for ( i = 0; i < 4; i++ ) {
        for ( x = 0; x < 23; x++ ) pc.printf("\304");
        pc.printf("\302");
    }
   
    pc.printf("\n\r\t\263\t\033[%dmRange Trim\033[%dm\t\263\t\033[%dmadc_op31\033[%dm\t\263\t\033[%dmadc_op223\033[%dm\t\263\t\033[%dmdelta_adc_op\033[%dm\t\263",34,32,34,32,34,32,34,32);

    //d_adc_op192[3] = 0xC0; //added for debug. Remove!

    for ( reg_val06 = 0x00; reg_val06 <= reg_val06_max; reg_val06 = (reg_val06 + 1)) {

        pc.printf("\n\r\t\303");
        for ( i = 0; i < 4; i++ ) {
            for ( x = 0; x < 23; x++ ) pc.printf("\304");
            if ( i < 3) pc.printf("\305");
            else  pc.printf("\264");
        }
        if ( (d_adc_op192[reg_val06] > 0xBE) && (d_adc_op192[reg_val06] < 0xC2))
                    pc.printf("\n\r\t\263\t\033[%dm   0x%2.2X\t\t\263\t   0x%2.2X\t\t\263\t   0x%2.2X\t\t\263\t    0x%2.2X\033[%dm\t\263", 31, reg_val06, adc_op31[reg_val06], adc_op223[reg_val06], d_adc_op192[reg_val06], 32);
        else 
            pc.printf("\n\r\t\263\t   0x%2.2X\t\t\263\t   0x%2.2X\t\t\263\t   0x%2.2X\t\t\263\t    0x%2.2X\t\263", reg_val06, adc_op31[reg_val06], adc_op223[reg_val06], d_adc_op192[reg_val06]);             
    }

    pc.printf("\n\r\t\300");
    for ( i = 0; i < 4; i++ ) {
        for ( x = 0; x < 23; x++ ) pc.printf("\304");
        if ( i < 3) pc.printf("\301");
        else  pc.printf("\331");
    }
       
    get_new_val(&reg_val06);      
    i2c_write_fn(&i2c,0x06,reg_val06);
    

    pc.printf("\n\n\n\r\t\033[%dmFinal Range trim = 0x%2.2X\033[%dm ", 45, reg_val06, 40); 

    pc.printf("\n\n\n\r\t\033[%dmDo you want to continue with offset trim. Press ",36);  
    pc.printf("\n\n\r\t  'c' - Continue ");
    pc.printf("\n\n\r\t  'e' - Exit ");
    pc.printf("\n\n\n\r\tYour Selection : \033[%dm",32);                          
    temp = 0;
    while ( temp!='c' && temp!='e') {
        temp = pc.getc();
    }
    if (temp == 'e') return;

    //*****************************************************************
    //******   ADC Offset trim test
    //*****************************************************************    


    draw_sig_line();
    
    pc.printf("\033[%dm ", 31);//change text color to red 
    pc.printf("\n\n\n\n\r\tStarting Offset trim \n\r\t");  
    for ( i = 0; i<19; i++) pc.printf("\315");
    pc.printf("\033[%dm ", 32);//change text color to green   

    temp = 0;
    pc.printf("\n\n\n\r\t\033[%dmSet Voc = 16mV (2mV x 8). Press 'c' to continue: \033[%dm",36,32);  
    while ( temp!='c') {
        temp = pc.getc();
    }
    // determine trim direction
 
    i2c_write_fn(&i2c,0x14,adc_op8); //Writing starting value in ADC
    pc.printf("\n\n\r\tAbout to start ADC conversion. 0 -> 1 -> 0 transition should be seen on DATA2_CLK");
    wait_ms(5);                    
    i2c_write_fn(&i2c,0x0D,0x03); //tm_adc_en = tm_adc_go = 1; start conversion
    wait_ms(20); //to make sure conversion is complete
    adc_op8 = i2c_read_fn(&i2c,0x14);        
    pc.printf("\n\n\r\tadc_op8 = 0x%2.2X ",adc_op8);

    temp = 0;    
    if (adc_op8 == 0x08) {
        temp = 1; // no trimming procedure
        pc.printf("\n\n\r\tNo Trimming Required. Woohoo");
        reg_val05 = i2c_read_fn(&i2c,0x05);
        adc_op8_disp[reg_val05] = adc_op8; // for displaying
    }
    
  
    adc_op8_old = adc_op8; //storing previous value in case the trim loop is not entered
    
              
    if (adc_op8_old < 0x08) {
        pc.printf("\n\n\r\tadc_op08 < 0x08; need to perform positive trim");
        reg_val05 = 0x10;
        adc_op8 = 0x10;//decimal 16. Set for proper function of the trim procedure      
    }
    
    if (adc_op8_old > 0x08) {
        pc.printf("\n\n\r\tadc_op08 > 0x08; need to perform negative trim");
        reg_val05 = 0x00;
        //adc_op8 = 0x00;
    }
    
    reg_val05_strt = reg_val05; //storing the starting value
    
    //Start trim

    while (temp != 1) {
        i2c_write_fn(&i2c,0x05,reg_val05); //programming offset trim
        adc_op8_old = adc_op8; //storing previous value
        i2c_write_fn(&i2c,0x14,adc_op8); //Writing starting value in ADC
        wait_ms(5);                    
        i2c_write_fn(&i2c,0x0D,0x03); //tm_adc_en = tm_adc_go = 1; start conversion
        wait_ms(20); //to make sure conversion is complete
        adc_op8 = i2c_read_fn(&i2c,0x14);
        adc_op8_disp[reg_val05] = adc_op8; // for displaying 
               
        if ((adc_op8 == 0x08) || ((adc_op8 > 0x08) && (adc_op8_old < 0x08)) || ((adc_op8 < 0x08) && (adc_op8_old > 0x08))) {
          //  pc.printf("\n\n\r\tI'm exiting.");
          //  pc.printf("\n\r\t\t\263\t adc_op8 =  0x%2.2X\t\t\263\t  adc_op8_old = 0x%2.2X\t\t\263 ", adc_op8, adc_op8_old);
             break; // exit loop
        }
        if ((reg_val05 == 0x0F) || (reg_val05 == 0x1F)) {
            pc.printf("\n\n\r\tTest Failed."); 
            break; // exit loop
        }
        reg_val05 = reg_val05 + 0x01;
      //  pc.printf("\n\r\t\t\263\t reg_val05 =  0x%2.2X\t\t\263\t  adc_op8 = 0x%2.2X\t\t\263 ", reg_val05, adc_op8);
                                           
    }
    //Printing Result table

    pc.printf("\n\n\n\r\t\t\332");
    for ( i = 0; i < 2; i++ ) {
        for ( x = 0; x < 23; x++ ) pc.printf("\304");
        pc.printf("\302");
    }    
    pc.printf("\n\r\t\t\263\t\033[%dmOffset Trim\033[%dm\t\263\t\033[%dmadc_op8\033[%dm\t\t\263", 34, 32, 34, 32);    
    for ( temp = reg_val05_strt; temp <= reg_val05; temp = (temp + 1) ) {
           
        pc.printf("\n\r\t\t\303");
        for ( i = 0; i < 2; i++ ) {
            for ( x = 0; x < 23; x++ ) pc.printf("\304");
            if ( i < 1) pc.printf("\305");
            else  pc.printf("\264");
        }
        pc.printf("\n\r\t\t\263\t  0x%2.2X\t\t\263\t  0x%2.2X\t\t\263 ", temp, adc_op8_disp[temp]);
    }
        
    pc.printf("\n\r\t\t\300");
    for ( i = 0; i < 2; i++ ) {
        for ( x = 0; x < 23; x++ ) pc.printf("\304");
        if ( i < 1) pc.printf("\301");
        else  pc.printf("\331");
    }
        
    if (adc_op8 > 0x08) d_adc_op = adc_op8 - 0x08;
    else d_adc_op = 0x08 - adc_op8;

    if (adc_op8_old > 0x08) d_adc_op_old = adc_op8_old - 0x08;
    else d_adc_op_old = 0x08 - adc_op8_old; 
    
    if (d_adc_op > d_adc_op_old) {
        reg_val05 = reg_val05 - 0x01;
        i2c_write_fn(&i2c,0x05,reg_val05); //programming offset trim
    }
    pc.printf("\n\n\n\r\t\033[%dmFinal Offset trim = 0x%2.2X\033[%dm", 45, reg_val05, 40);//displaying in Magenta background
    
    pc.printf("\n\n\n\r\t\033[%dmDo you want to continue with rest of the adc test. Press ",36);  
    pc.printf("\n\n\r\t  'c' - Continue ");
    pc.printf("\n\n\r\t  'e' - Exit ");
    pc.printf("\n\n\n\r\tYour Selection : \033[%dm",32);                          
    temp = 0;
    while ( temp!='c' && temp!='e') {
        temp = pc.getc();
    }
    if (temp == 'e') return;    
    draw_sig_line();
        
    //*****************************************************************
    //******   measuring adc outputs different inputs
    //*****************************************************************
    
    pc.printf("\033[%dm ", 31);//change text color to red 
    pc.printf("\n\n\n\n\r\tMeasure ADC output for different inputs \n\r\t");  
    for ( i = 0; i<39; i++) pc.printf("\315");
    pc.printf("\033[%dm ", 32);//change text color to green 

    adc_meas(&i2c,16,2); //adc measurement for 16 x 2mV
    adc_meas(&i2c,24,2);    
    adc_meas(&i2c,32,2);
    adc_meas(&i2c,64,2);
    adc_meas(&i2c,97,2);
    adc_meas(&i2c,128,2);
    adc_meas(&i2c,196,2);
    adc_meas(&i2c,250,2);
    
    pc.printf("\n\n\n\r\t\033[%dmDo you want to continue with rest of the adc test. Press ",36);  
    pc.printf("\n\n\r\t  'c' - Continue ");
    pc.printf("\n\n\r\t  'e' - Exit ");
    pc.printf("\n\n\n\r\tYour Selection : \033[%dm",32);                          
    temp = 0;
    while ( temp!='c' && temp!='e') {
        temp = pc.getc();
    }
    if (temp == 'e') return;    
    draw_sig_line();     
    
    //*****************************************************************
    //******   measuring adc outputs different Range Settings
    //*****************************************************************
        
    pc.printf("\033[%dm ", 31);//change text color to red 
    pc.printf("\n\n\n\n\r\tMeasure ADC output for different range settings \n\r\t");  
    for ( i = 0; i<47; i++) pc.printf("\315");
    pc.printf("\033[%dm ", 32);//change text color to green 

    reg_val04 = i2c_read_fn(&i2c,0x04); //Bits [3:2] of 0x04 contains range settings
    
    i2c_write_fn(&i2c,0x04,(reg_val04 & 0xF3)); //Range = 00 => 1mV
    adc_meas(&i2c,128,1); //adc measurement for 16 x 2mV
    
    i2c_write_fn(&i2c,0x04,(reg_val04 | 0x0C)); //Range = 11 => 4mV
    adc_meas(&i2c,32,4); //adc measurement for 32 x 4mV    

    i2c_write_fn(&i2c,0x04,reg_val04); //Setting back the original value 
    
    pc.printf("\n\n\n\r\t\033[%dmDo you want to continue with rest of the adc test. Press ",36);  
    pc.printf("\n\n\r\t  'c' - Continue ");
    pc.printf("\n\n\r\t  'e' - Exit ");
    pc.printf("\n\n\n\r\tYour Selection : \033[%dm",32);                          
    temp = 0;
    while ( temp!='c' && temp!='e') {
        temp = pc.getc();
    }
    if (temp == 'e') return;    
    draw_sig_line(); 

    //*****************************************************************
    //******   measuring adc outputs for negative inputs
    //*****************************************************************    

    pc.printf("\033[%dm ", 31);//change text color to red 
    pc.printf("\n\n\n\n\r\tMeasure ADC output for negative inputs \n\r\t");  
    for ( i = 0; i<39; i++) pc.printf("\315");
    pc.printf("\033[%dm ", 32);//change text color to green
    
    pc.printf("\033[%dm", 34);//change text color to blue
    pc.printf("\n\n\n\r\tInstructions: \n\r\t");
    for ( i = 0; i<13; i++) pc.printf("\304");    
    pc.printf("\n\n\r\t  1. Set Voc = 0. Wait for a second "); 
    pc.printf("\n\n\r\t  2. Change the input connnection such that the input is negative ");            
    pc.printf("\n\n\r\t  3. Increase Voc to 450mV");
    pc.printf("\033[%dm ", 32);//change text color to green
    temp = 0;
    pc.printf("\n\n\n\r\t\033[%dmPress 'c' to continue: \033[%dm",36,32);  
    while ( temp!='c') {
        temp = pc.getc();
    }
    //Making sure input polarity detector outputs are correct.
    i2c_write_fn(&i2c,0x10,0x10); //tm_PolComp_en = 1
    pc.printf("\n\n\n\r\tPolarity comparitor was enabled to have correct outputs (vinB_high = 1)");  
    wait_ms(1);
    i2c_write_fn(&i2c,0x10,0x00); //tm_PolComp_en = 0 
    pc.printf("\n\n\r\tPolarity comparitor disabled");
    adc_meas(&i2c,16,2); //adc measurement for 16 x 2mV  
    adc_meas(&i2c,128,2);
    adc_meas(&i2c,250,2);

    pc.printf("\n\n\n\r\t\033[%dmDo you want to continue to ADC ACP mode test. Press ",36);  
    pc.printf("\n\n\r\t  'c' - Continue ");
    pc.printf("\n\n\r\t  'e' - Exit ");
    pc.printf("\n\n\n\r\tYour Selection : \033[%dm",32);                          
    temp = 0;
    while ( temp!='c' && temp!='e') {
        temp = pc.getc();
    }
    if (temp == 'e') return;    
    draw_sig_line(); 

    //*****************************************************************
    //******   Verify ADC operation for ACP mode
    //*****************************************************************    

    pc.printf("\033[%dm ", 31);//change text color to red 
    pc.printf("\n\n\n\n\r\tVerify ADC operation in ACP mode \n\r\t");  
    for ( i = 0; i<32; i++) pc.printf("\315");
    pc.printf("\033[%dm ", 32);//change text color to green
    reg_val07 = i2c_read_fn(&i2c,0x07); //reading the initial pmos off setting
    i2c_write_fn(&i2c,0x07,(reg_val07 | 0x0F)); //PMOS_off = 4’hF → ACP mode. In this mode ADC operates as a comparator checking input against 250*lsb
    pc.printf("\n\n\r\tCSI066a switched to ACP mode by setting PMOS_off = 4'hF");          

    pc.printf("\033[%dm", 34);//change text color to blue
    pc.printf("\n\n\n\r\tInstructions: \n\r\t");
    for ( i = 0; i<13; i++) pc.printf("\304");    
    pc.printf("\n\n\r\t  1. Set Voc to 480mV (240 x 2mV)");            
    pc.printf("\033[%dm ", 32);//change text color to green 
    temp = 0;
    pc.printf("\n\n\n\r\t\033[%dmPress 'c' to continue: \033[%dm",36,32);  
    while ( temp!='c') {
        temp = pc.getc();
    }    
    pc.printf("\n\n\n\r\tPerforming hot-read on adc_comp_out (0x13[3])"); 
    pc.printf("\033[%dm", 34);//change text color to blue
    pc.printf("\n\n\n\r\tInstructions: \n\r\t");
    for ( i = 0; i<13; i++) pc.printf("\304");    
    pc.printf("\n\n\r\t  1. Monitor DATA1_clk on oscilloscope. DATA1_clk should be low in the beginning ");           
    pc.printf("\n\n\r\t  2. Ramp Voc from 480mV --> 520mV (240lsb --> 260lsb). Stop when DATA1_CLK transitions from 0 --> 1 ");
    pc.printf("\n\n\r\t  3. Record Voc / 2mV. Record it as\033[%dm ACP_neg_fb_dis \033[%dm", 47, 40); //background white    
    pc.printf("\033[%dm ", 32);//change text color to green     
      
    i2c_hotread_fn(&i2c,0x13,3); //Performing hot-read on [3] of 0x13  

    pc.printf("\033[%dm", 34);//change text color to blue
    pc.printf("\n\n\n\r\tInstructions: \n\r\t");
    for ( i = 0; i<13; i++) pc.printf("\304");    
    pc.printf("\n\n\r\t  1. Reduce Voc to 0V. "); 
    pc.printf("\n\n\r\t  2. Switch input connections such that input is positive");
    pc.printf("\n\n\r\t  3. Set Voc to 480mV (240 x 2mV)");                 
    pc.printf("\033[%dm ", 32);//change text color to green 
    temp = 0;
    pc.printf("\n\n\n\r\t\033[%dmPress 'c' to continue: \033[%dm",36,32);  
    while ( temp!='c') {
        temp = pc.getc();
    }
    i2c.~I2C();
    I2C i2c2(p9,p10); //Creating new object after hot-read
    i2c2.frequency((frequ/2)*1000);
    LPC_PINCON->PINMODE_OD0 = (LPC_PINCON->PINMODE_OD0  | 0x0003); // To make p9 & P10 open_drain       
    i2c2.stop(); //add a stop after hot-read
    //Making sure input polarity detector outputs are correct.
    i2c_write_fn(&i2c2,0x10,0x10); //tm_PolComp_en = 1
    pc.printf("\n\n\n\r\tPolarity comparitor was enabled to have correct outputs (vinB_high = 1)");  
    wait_ms(1);
    i2c_write_fn(&i2c2,0x10,0x00); //tm_PolComp_en = 0 
    pc.printf("\n\n\r\tPolarity comparitor disabled");
    
    pc.printf("\n\n\n\r\tPerforming hot-read on adc_comp_out (0x13[3])");

    pc.printf("\033[%dm", 34);//change text color to blue
    pc.printf("\n\n\n\r\tInstructions: \n\r\t");
    for ( i = 0; i<13; i++) pc.printf("\304");    
    pc.printf("\n\n\r\t  1. Monitor DATA1_CLk on the oscillscope "); 
    pc.printf("\n\n\r\t  2. DATA1_CLk should be low initially");            
    pc.printf("\n\n\r\t  3. Ramp Voc from 480mV --> 520mV (240lsb --> 260lsb). Stop when DATA1_CLK transitions from 0 --> 1 ");
    pc.printf("\n\n\r\t  4. Record Voc / 2mV. Record it as\033[%dm ACP_pos_fb_dis \033[%dm", 47, 40); //yellow background   
    pc.printf("\033[%dm ", 32);//change text color to green 

    i2c_hotread_fn(&i2c2,0x13,3); //Performing hot-read on [3] of 0x13 

    i2c2.~I2C();
    I2C i2c3(p9,p10); //Creating new object after hot-read
    i2c3.frequency((frequ/2)*1000);
    LPC_PINCON->PINMODE_OD0 = (LPC_PINCON->PINMODE_OD0  | 0x0003); // To make p9 & P10 open_drain       
    i2c3.stop(); //add a stop after hot-read     
    i2c_write_fn(&i2c3,0x07,reg_val07); //Restoring Reg 0x07 value
    pc.printf("\n\n\n\r\t\033[%dmADC Test finally done!.. Phew\033[%dm", 45, 40);//displaying in Magenta background    
                         
}                   
    