#include "mbed.h"

extern Serial pc;
extern int frequ; //unit kHz
extern char dev_addr; //fixed

char get_half_byte(int *); //defined in I2C_read.cpp

void i2c_write() {
    char reg_ptr = 0x55;
    char reg_data = 0xaa;
    char temp;
    int flag1 = 0;
    I2C i2c(p9,p10);
    LPC_PINCON->PINMODE_OD0 = (LPC_PINCON->PINMODE_OD0  | 0x0003); // To make p9 & P10 open_drain
    //Read Register Pointer
    pc.printf("\n\n\n \r\tYahoooo! Lets program a Register");
    while (!flag1) {
        pc.printf("\n\n\n \r\tEnter Register Address in hex (0 to 17): ");
        reg_ptr = get_half_byte(&flag1);
        if (flag1 == 1) {
            reg_ptr = reg_ptr << 4;
            temp = get_half_byte(&flag1);
            reg_ptr = (reg_ptr | temp);
        }
        if (flag1==0) pc.printf(" \033[%dm Invalid Chracter!! No worries, let us try again \033[%dm",41,40);
    } 
    //Read Register Data
    flag1 = 0;
    while (!flag1) {
        pc.printf("\n\n \r\tEnter Data in hex (00 to ff): ");
        reg_data = get_half_byte(&flag1); 
        if (flag1 == 1) {
            reg_data = reg_data << 4;
            temp = get_half_byte(&flag1);
            reg_data = (reg_data | temp);
        }
        if (flag1==0) pc.printf(" \033[%dm Invalid Chracter!! No worries, let us try again \033[%dm",41,40);
    }                  

    pc.printf("\n\n\n\r\t\033[%dm", 44);//change backround to blue
    pc.printf(" Device Address (fixed) = 0x%2.2X ; Register Pointer = 0x%2.2X ; Register Data = 0x%2.2X ",dev_addr, reg_ptr, reg_data);
    pc.printf("\033[%dm", 40);//change backround to black    
    
    pc.printf("\n\n\n \r\tContinue Write? (y/n) : ");  
    temp = 0;
    while ( temp!='y' && temp!='n') {
        temp = pc.getc();
    }
    if (temp == 'n') {
        pc.printf("\n\n \r\tAborting Register Write :(");
        return;
    }
    i2c.frequency(frequ*1000);
    i2c.stop(); //add a stop after hot-read
    wait_us(10);
    i2c.start();
    flag1 = i2c.write(dev_addr);
    if (flag1 != 1) pc.printf("\n\n\n \r\tNo Ack for dev addr :(");
    flag1 = i2c.write(reg_ptr);
    if (flag1 != 1) pc.printf("\n\n \r\tNo Ack reg pointer :(");    
    flag1 = i2c.write(reg_data); 
    if (flag1 != 1) pc.printf("\n\n \r\tNo Ack data :(");           
    wait_us(5);
    i2c.stop();
    pc.printf("\n\n\n \r\tYeahhh! Register Write Complete");
    if (flag1 != 1) pc.printf("\n\n\n\r\t\033[%dm But the Write operation might not be successful since no 'Ack' was received :(  \033[%dm",45,40);
    pc.printf("\n\n\n\r");             
    wait_us(5);
    i2c.~I2C();   
}  