#include "mbed.h"

extern Serial pc;
extern int frequ = 50; //unit kHz
extern char dev_addr = 0x00; //fixed

char get_half_byte(int *flag) {
    char cur_char;
    cur_char = pc.getc();
    if ( cur_char >= '0' && cur_char <= '9' ) {
        cur_char = cur_char - '0';
        *flag = 1;
    }
    else if ( cur_char >= 'a' && cur_char <= 'f') {
        cur_char = cur_char - 'a'+10;
        *flag = 1;
    }
    else if( cur_char >= 'A' && cur_char <= 'F') {
        cur_char = cur_char - 'A'+10;
        *flag = 1;
    }
    else *flag = 0; 
    return cur_char;
}   

void i2c_read() {
    char reg_ptr = 0x55;
    char reg_data = 0x00;
    char temp;
    int flag1 = 0;
    char count = 0;
    I2C i2c(p9,p10);
    LPC_PINCON->PINMODE_OD0 = (LPC_PINCON->PINMODE_OD0  | 0x0003); // To make p9 & P10 open_drain
    pc.printf("\n\n\n \r\tYahoooo! Lets read a Register");
    //Read the number of Registers
    while (!flag1) {
            pc.printf("\n\n\n\r\tEnter the number of registers to read (1 - 16) and hit 'enter' key: ");
            temp = '0';
            count = 0;
            while (temp != '\r') {  //look for enter key
                count = (count * 10) + (temp - '0');  // converting to number
                temp = pc.getc();
                if ((temp < '0' || temp > '9') && temp !='\r') {
                    pc.printf(" \n\r\t\033[%dm Invalid Chracter!! No worries, let us try again \033[%dm",41,40);
                    break;
                }
            }
            if (count >= 1 && count <= 16 && temp == '\r') flag1 = 1;
            else if (temp == '\r') pc.printf(" \n\r\t\033[%dm Invalid Chracter!! No worries, let us try again \033[%dm",41,40);
    }          
Re_enter:
    flag1 = 0;
    //Read Pointer to the Register that needs to be read
    while (!flag1) {
        pc.printf("\n\n \r\tEnter Register Address in hex (0 to f): ");
        reg_ptr = get_half_byte(&flag1);
        if (flag1==0) pc.printf(" \033[%dm Invalid Chracter!! No worries, let us try again \033[%dm",41,40);
    }          

    pc.printf("\n\n\n\r\t\033[%dm", 44);//change backround to blue
    pc.printf(" Device Address (fixed) = 0x%2.2X ; Register Pointer = 0x%2.2X ; Count = %d ",dev_addr, reg_ptr, count);
    pc.printf("\033[%dm", 40);//change backround to black
            
    pc.printf("\n\n\n \r\tContinue Read? (y/n) [Press 'e' to re-enter Pointer]: ");  
    temp = 0;
    while ( temp!='y' && temp!='n' && temp!='e') {
        temp = pc.getc();
    }
    if (temp == 'n') {
        pc.printf("\n\n \r\tAborting Register Read :(\n\n\r");
        return;
    }
    if (temp == 'e') {
        pc.printf(" \n\n\n \r\tOk, let us try again :)");
        goto Re_enter;
    }
    i2c.frequency(frequ*1000);
    i2c.stop(); //add a stop after hot-read
    wait_us(10);
    for ( ; (count > 0) && (reg_ptr < 0x10); count = count - 1) {
        i2c.start();
        flag1 = i2c.write(dev_addr); 
        if (flag1 != 1) pc.printf("\n\n\n \r\tNo Ack for dev addr :(");
        flag1 = i2c.write(reg_ptr);
        if (flag1 != 1) pc.printf("\n\n \r\tNo Ack reg pointer :(");
        i2c.stop();
        wait_us(10);
        i2c.start();
        flag1 = i2c.write(dev_addr | 0x01); //lsb 1 for read
        if (flag1 != 1) pc.printf("\n\n \r\tNo Ack for dev addr :(");         
        reg_data = i2c.read(0); //0- donot send ack after read is done         
        pc.printf("\n\n\n \r\tRead 0x%2.2X = 0x%2.2X ", reg_ptr, reg_data);
        wait_us(5);
        i2c.stop();      
        if (reg_data == 0xff) pc.printf("  |\033[%dm  Register read might not be sucessfull \033[%dm ",45,40);
        reg_ptr = reg_ptr + 1;
        wait_us(120);        
    }
    pc.printf("\n\n\n \r\tYeahhh! Register Read Complete\n\n\r");
    i2c.~I2C();   
}  