#include "mbed.h"
#include "ina226.h"
#include "Motor.h"
#include "math.h"
#include "controller.h"

#define VCC 12
#define R_MOT 12.5

#define G_I1 0.60
#define G_F1 1.15

#define G_I2 0.0
#define G_F2 0.0

void controller(Motor& mot, INA226& currentMonitor, float& delay);
void getData(Motor& mot, INA226& currMon);

DigitalOut led(LED_RED);

DigitalIn sw(SW1);

Motor motorOne(D7,D2,D3);
Motor motorTwo(D6,D4,D5);

Serial pc(USBTX,USBRX);

I2C i2c(I2C_SDA,I2C_SCL);

INA226 currMonOne(i2c,INA226_1<<1);
INA226 currMonTwo(i2c,INA226_2<<1);

Controller ctrlOne(motorOne,currMonOne);
Controller ctrlTwo(motorTwo,currMonTwo);

float q = 0.0f;

int main()
{
    //float delay1 = 0.0f;
    //float delay2 = 0.0f;
    led = 1;
    pc.printf("Initialising...\r\n");
    motorOne.SetDirection(FORWARD);
    motorOne.SetSpeed(0.15f);
    motorTwo.SetDirection(FORWARD);
    motorTwo.SetSpeed(0.15f);
    short config = currMonTwo.read(REG_CONF);
    
    pc.printf("conf: %x\r\n",config);
    config = currMonOne.read(REG_CONF);
    pc.printf("conf: %x\r\n",config);
    while(sw != 0)
    {
        led = !led;
        wait(0.2f);
        pc.printf("Current: %f, %f\r\n",currMonOne.getCurrent(),currMonTwo.getCurrent());
    }
    pc.printf("GO!\r\n");
    led = 0;
    while (true) {
        pc.printf("\n####JOINT 1####\r\n");
        ctrlOne.Update();
        pc.printf("\n####JOINT 2####\r\n");
        ctrlTwo.Update();
    }
}

void getData(Motor& mot, INA226& currMon)
{
    mot.SetSpeed(1.0f);
    mot.SetDirection(FORWARD);
    wait(1.0f);
    printf("FORWARD\r\n");
    for(int i = 10;i>0;i--)
    {
        mot.SetSpeed((float)i/10);
        printf("speed: %f, current: %f\r\n",mot.GetSpeed(),currMon.getCurrent());
    }
    mot.SetSpeed(1.0f);
    mot.SetDirection(BACKWARD);
    wait(1.0f);
    printf("REVERSE\r\n");
     for(int i = 10;i>0;i--)
    {
        mot.SetSpeed((float)i/10);
        printf("speed: %f, current: %f\r\n",mot.GetSpeed(),currMon.getCurrent());
    }
}

void controller(Motor& mot, INA226& currentMonitor, float& delay)
{
    /*float duty = mot.GetSpeed();
    float current = currentMonitor.getCurrent();
    float gi=G_I1;
    float gf=G_F1;
    if(fabs(current) > 750)
    {
        //printf("STALL!\n");
        gi=G_I2;
        gf=G_F2;
        delay = 0;
    }
    
    //speed calculation
    float speed = 0;
    
    if(current == 0)
    {
        speed = 0;
    }
    else
    {
        char sign = (current < 0) ? -1 : 1;
        
        float v_supply = VCC * duty;
        
        float v_back = R_MOT * fabs(current) / 1000;
        pc.printf("supply voltage: %f, back emf: %f\r\n",v_supply,v_back);
        
        speed = sign*(v_supply - v_back)/12;
    }
    
    float new_speed = -gi * speed + delay + 0.14;
    
    if(new_speed > 1.0)
    {
        new_speed = 1.0;
    }
    else if(new_speed < -1.0)
    {
        new_speed = -1.0;
    }
    
    delay = (new_speed - 0.14) * gf;
    pc.printf("current:%f\r\n speed:%f\r\n newspeed: %f\r\n delay: %f\r\n",current,speed, new_speed,delay);
    mot.SetSpeed(fabs(new_speed));
    if(new_speed > 0)
        mot.SetDirection(BACKWARD);
    else
        mot.SetDirection(FORWARD);*/
}