/*
 * ina226.h
 *
 * driver for INA226 current monitor chip
 *
 * Created: 03/11/2015 17:13:11
 *  Author: Jack
 */ 


#ifndef INA226_H_
#define INA226_H_

#include "mbed.h"

#define INA226_1    0x40
#define INA226_2    0x41

/*
//INA226 register addresses
#define REG_CONF    0x00
#define REG_SHNT    0x01
#define REG_BUS     0x02
#define REG_PWR     0x03
#define REG_CURR    0x04
#define REG_CAL     0x05
#define REG_MASK    0x06
#define REG_ALRT    0x07
#define REG_MFG     0xFE
#define REG_DIE     0xFF
*/
enum INA226REG
{
    REG_CONF=0x00,
    REG_SHNT=0x01,
    REG_BUS=0x02,
    REG_PWR=0x03,
    REG_CURR=0x04,
    REG_CAL=0x05,
    REG_MASK=0x06,
    REG_ALRT=0x07,
    REG_MFG=0xFE,
    REG_DIE=0xFF
};
//BITS
//CONFIG REGISTER
#define CONF_DEFAULT 0x4000

#define RST 15
#define AVG2 11
#define AVG1 10
#define AVG0 9
#define VBUSCT2 8
#define VBUSCT1 7
#define VBUSCT0 6
#define VSHCT2 5
#define VSHCT1 4
#define VSHCT0 3
#define MODE3 2
#define MODE2 1
#define MODE1 0

//MASK/ENABLE REGISTER
#define SOL 15  //shunt voltage over-voltage
#define SUL 14 //shunt voltage under-voltage
#define BOL 13 //bus voltage over-voltage
#define BUL 12 //bus voltage under-voltage
#define POL 11 //power over limit
#define CNVR 10 //conversion ready
#define AFF 4 //alert function flag
#define CVRF 3 //conversion ready flag
#define OVF 2 //math overflow flag
#define APOL 1 //alert polarity
#define LEN 0 //alert latch enable

#define _BV(bit) (1 << (bit))

/*
void ina226_init(I2C* i2c, char addr);
void ina226_write(I2C* i2c, char addr, char reg, short value);
short ina226_read(I2C* i2c, char addr, char reg);
*/

union shortToChar
{
    short u16;
    char u8[2];
};

class INA226
{
    public:
        INA226(I2C& theI2C, char address);
        void init();
        void write(INA226REG reg, short value);
        short read(INA226REG reg);
        float getCurrent();
    private:
        I2C& i2c;
        char i2cAddress;
};


#endif /* INA226_H_ */