#include "ina226.h"

INA226::INA226(I2C& theI2C, char address)
    :i2c(theI2C), i2cAddress(address)
{
    init();
}

void INA226::init()
{
    //set up config register            //256 averages          //continuous shunt voltage conversion
    short write_byte = CONF_DEFAULT |_BV(AVG2) | _BV(AVG0) | _BV(MODE3) | _BV(MODE1);
    
    write(REG_CONF, write_byte);
    //set up calibration (full range ~1.6A)
    write(REG_CAL, 0x0800);
}

void INA226::write(INA226REG reg, short value)
{
    shortToChar stc;
    char cmd[3];
    stc.u16 = value;
    
    cmd[0] = reg;
    cmd[1] = stc.u8[1];
    cmd[2] = stc.u8[0];
    
    i2c.write(i2cAddress,cmd,3);
}

short INA226::read(INA226REG reg)
{
    shortToChar stc;
    
    char cmd[2];
    cmd[0] = reg;
    i2c.write(i2cAddress,cmd,1);
    
    i2c.read(i2cAddress, cmd, 2);
    stc.u8[1] = cmd[0];
    stc.u8[0] = cmd[1];
    
    return (stc.u16);
}

float INA226::getCurrent()
{
    short curr = read(REG_CURR);
    return curr/20;
}