#include "controller.h"


Controller::Controller(Motor& motor, INA226& currentMonitor)
    :currMon(currentMonitor),theMotor(motor),delayElement(0)
{
}

void Controller::Update()
{
    float gi1 = 0.9f;
    float gf1 = 1.1f;
    
    float gi2 = 0.1f;
    float gf2 = 0.0f;
    
    float gi = gi1;
    float gf = gf1;
    float duty = theMotor.GetSpeed();
    printf("duty: %f\r\n",duty);
    
    float currentVal = currMon.getCurrent();
    printf("current: %f\r\n",currentVal);

    float sign = (currentVal < 0) ? -1.0f : 1.0f;    

    float speed = sign * ((1000*duty - fabs(currentVal))/1000);
    printf("speed: %f\r\n",speed);
    
    if((fabs(speed) < 0.03) && (fabs(currentVal) > 800))
    {
        printf("STALL!\r\n");
        gi = gi2;
        gf = gf2;
    }
    else
    {
        gi = gi1;
        gf = gf1;
    }
    
    float new_speed = -gi * speed + delayElement;
    
    if(new_speed > 1.0)
    {
        new_speed = 1.0;
    }
    else if(new_speed < -1.0)
    {
        new_speed = -1.0;
    }
    
    if(new_speed < 0.0f)
        theMotor.SetDirection(FORWARD);
    else
        theMotor.SetDirection(BACKWARD);
    printf("delay: %f\r\n",delayElement);    
    theMotor.SetSpeed(fabs(new_speed));
    printf("new speed: %f\r\n",new_speed);
    delayElement = new_speed * gf;
}

float Controller::DutyFunc(float duty)
{
    float ret = 1133*duty - 22;
    return ret;
}

float Controller::Threshold(float input)
{
    if(input > 1.0f)
        return 1.0f;
    else if(input < -1.0f)
        return -1.0f;
    else
        return input;
}