#ifndef MOTOR_H_
#define MOTOR_H_

#include "mbed.h"

enum MotDir {NONE,FORWARD,BACKWARD};

class Motor
{
    public:
        Motor(PinName enablePin, PinName forwardPin, PinName backwardPin);
        void SetDirection(MotDir direction);
        void SetSpeed(float speed);
        MotDir GetDirection();
        float GetSpeed();
    private:
        MotDir motorDirection;
        PwmOut motorEnable;
        DigitalOut motorForward,motorBackward;
        float motorSpeed;
};

#endif