#include "Motor.h"

Motor::Motor(PinName enablePin, PinName forwardPin, PinName backwardPin)
    :motorEnable(enablePin),motorForward(forwardPin),motorBackward(backwardPin),motorSpeed(0)
{
    motorEnable.period(0.005f);
}

void Motor::SetDirection(MotDir direction)
{
    switch(direction)
    {
        case NONE:
            motorForward = 0;
            motorBackward = 0;
            break;
        case FORWARD:
            motorForward = 1;
            motorBackward = 0;
            break;
        case BACKWARD:
            motorForward = 0;
            motorBackward = 1;
            break;
    }
    
    motorDirection = direction;
}

MotDir Motor::GetDirection()
{
    return motorDirection;
}

void Motor::SetSpeed(float speed)
{
    motorEnable.write(speed);
    motorSpeed = speed;
}

float Motor::GetSpeed()
{
    return motorSpeed;
}
