
#include "mbed.h"
#include "C12832_lcd.h"
 
class Counter {
public:
    Counter(PinName pin) : _interrupt(pin) {        // create the InterruptIn on the pin specified to Counter
        _interrupt.rise(this, &Counter::increment); // attach increment function of this counter instance
        _interrupt.fall(this, &Counter::increment);
    }
 
    void increment() {
        _count++;
    }
 
    int read() {
        return _count;
    }
 
private:
    InterruptIn _interrupt;
    volatile int _count;
};


C12832_LCD lcd;
Counter counter(p14);

int main() {
    while(1) {
        
        lcd.locate(0,0);
        lcd.printf("Count so far: %d\n", counter.read());
        wait(0.5);
    }
}