
#include "mbed.h"

//
// ignore interrupt version till we discuss that topic
//

#ifdef INTERRUPT
InterruptIn fire(p14);
DigitalOut  led(LED1);
DigitalOut  flash(LED4);

void ISR1() {
    led = !led;
}

int main()
{
    fire.rise(&ISR1);
    fire.fall(&ISR1);
    
    while (1) {
        flash = !flash;
        wait(0.25);
    }   
}

#endif

#include "mbed.h"
#include "C12832_lcd.h"

C12832_LCD lcd;

BusIn joy(p15,p12,p13,p16);
InterruptIn fire(p14);

BusOut leds(LED1,LED2,LED3,LED4);

int main()
{
    while(1) {
        if (fire) {
            leds=0xf;
            lcd.cls();
            lcd.locate(0,0);
            lcd.printf("\n\rFIRE = ON ");
            
        } else {
            leds=joy;
        
        if(joy == 0x8){
            lcd.cls();
            lcd.locate(0,0);
            lcd.printf("\n\rRIGHT = ON ");
        }
        else if(joy == 0x4){
            lcd.cls();
            lcd.locate(0,0);
            lcd.printf("\n\rLEFT = ON ");
            }
        else if(joy == 0x2){
            lcd.cls();
            lcd.locate(0,0);
            lcd.printf("\n\rDOWN = ON ");
            }
        else if(joy == 0x1){
            lcd.cls();
            lcd.locate(0,0);
            lcd.printf("\n\rUP = ON ");
            }
            else if(joy == 0x0){
                lcd.cls();
                lcd.locate(0,0);
                lcd.printf("\n\rNONE ");
            }
        }
        wait(0.1);
    }
}

