#include "mbed.h"
#include "HCSR04.h"

// Set's the Serial port
Serial pc(USBTX, USBRX);

// Defines the LED colors
DigitalOut led(LED_RED);
DigitalOut led2(LED_GREEN);

// Defines the sensors (Left and Right)
HCSR04 sensorLEFT(PTA12, PTD4);
HCSR04 sensorRIGHT(PTA4, PTA5);

// Get the left distance variable
int distLeft(int dLEFT){
    return dLEFT;    
}

// Get the right distance variable
int distRight(int dRIGHT){
    return dRIGHT;    
}


// The main() function
int main()
{
    
    // The loop() function
    while(1) {
        //left and right distance variables 
        int dLEFT = sensorLEFT.distance(CM);
        int dRIGHT = sensorRIGHT.distance(CM);
        
        // Writes the left and right distance variable
       pc.printf("SENSOR Left: %d \n\r\v",distLeft(dLEFT));
       pc.printf("SENSOR Right: %d \n\r\v",distRight(dRIGHT));
        
        // Delay
        wait(0.5);
        
        //LED control
        if(dRIGHT<=10) {
            led = 0;
            led2 = 1;
        }

        if(dRIGHT>=40) {
            led2 = 0;
            led = 1;
        }
        if(dRIGHT>=11 && dRIGHT<=39) {
            led2 = 0;
            led=0;
        }
    }
    
}





