/*
  Project: time_SetTime
  File: main.cpp
  Modified by: Dr. C. S. Tritt
  Last modified: 10/31/17 (v. 1.1)

  This program prompts the user for the current date and time and sets the
  Nucleo real time clock (RTC) accordingly. It demonstrates the use of C data
  and time functions (defined in time.h, which appears to be included by mbed).
  It also demonstrates reading keyboard input with echo and extracting numeric 
  values from strings.
  
  Versions
  
  1.1 - Fixed pass 0 error in time interval loop (switched from while to do 
  while).
  
  Notes & Limitations
  
  Entered date and time values are not validated.
  Nucleo LF newline behavior is assumed.
  Actual update interval is longer than wait time due to output times.

 * Based on mbed Example Program - timeHelloWorld
 * Copyright (c) 2006-2014 ARM Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
#include "mbed.h"

// Construct a serial object connected to PC.
Serial pc(USBTX, USBRX); // Speed will be 9600 Baud and format 8-N-1.

int main()
{
    time_t userTime_tt; // Current time as a time type (time_t) variable.
    struct tm userTime_tm; // Current time as a time structure (tm) variable.

    // Get current date from user...
    char cdString[9]; // Current date string. Allow room for LF/null.
    pc.printf("Enter current date (MM-DD-YY format):\n");
    int i = 0; // Array (character location) index. Reused below.
    while (i < 9) {
        if (pc.readable()) { // A charactr is waiting...
            cdString[i] = (char) pc.getc(); // Read a character.
            pc.putc(cdString[i]); // Echo the character, including LF.
            i++; // Increment i as each character is read.
        }
    }
    cdString[8] = (char) 0; // Manually insert null character over LF.
    pc.printf("cdString: %s\n", cdString); // Display string.
    int month, day, year; // Ints to hold month, day and year.
    sscanf(cdString, "%2d-%2d-%2d", &month, &day, &year);
    year = year + 2000; // Convert year to correct style.
    pc.printf("Month: %d, Day: %d, Year: %d\n", month, day, year);

    // Get current time from user...
    char tString[9]; // Current time string. Allow room for LF/null.
    pc.printf("Enter current 24-hour time (hh:mm:ss format):\n");
    i = 0; // Reuse index.
    while (i < 9) {
        if (pc.readable()) { // // A charactr is waiting...
            tString[i] = (char) pc.getc(); // Read a character.
            pc.putc(tString[i]); // Echo the character.
            i++; // Increment i as each character is read.
        }
    }
    tString[8] = (char) 0; // Manually insert null character over LF.
    pc.printf("tString: %s\n", tString); // Display string.
    int hour, min, sec; // Ints to hold hours, minutes and seconds.
    sscanf(tString, "%2d:%2d:%2d", &hour, &min, &sec);
    pc.printf("Hours: %d, Minutes: %d, Seconds: %d\n", hour, min, sec);
    
    // Get wait between screen updates interval in seconds...
    // Allow for short (1 and 2 character entries).
    char wString[4] = {"   "}; // Wait interval string.
    i = 0; // Reuse index.
    pc.printf("Enter update interval in seconds (999 max.):\n");
    do { // Read 3 chars or to LF.
        if (pc.readable()) { // // A charactr is waiting...
            wString[i] = (char) pc.getc(); // Read a character.
            pc.putc(wString[i]); // Echo the character.
            i++; // Increment i as each character is read.
        }
    } while (i < 4 && wString[i-1] != (char) 10);
    // The following line works regardless of # of digits entered!
    wString[i - 1] = (char) 0; // Manually insert null character over LF.
    pc.printf("wString: %s\n", wString); // Display string.
    int waitTime; // Time to wait between screen updates.
    sscanf(wString, "%d", &waitTime);
    pc.printf("Wait interval: %d\n", waitTime);
    
    // Fill standard library tm structure, hours, minutes & seconds required!
    userTime_tm.tm_year = year - 1900; // Convert to expected basis.
    userTime_tm.tm_mon = month - 1; // Convert to expected basis.
    userTime_tm.tm_mday = day;
    userTime_tm.tm_hour = hour;
    userTime_tm.tm_min = min;
    userTime_tm.tm_sec = sec;

    userTime_tt = mktime (&userTime_tm); // call mktime to create time_t type.

    set_time(userTime_tt);  // Set RTC time to entered time.

    while (true) { // Loop forever.
        time_t curTime_tt = time(NULL); // Get the current time as a time type.

        // Send output to PC...
        pc.printf("Time as seconds since January 1, 1970 = %d\n", curTime_tt);
        pc.printf("Current time in...\n");
        // The ctime string ends with a newline.
        pc.printf("...basic string format = %s", ctime(&curTime_tt));
        char tBuffer[32];
        strftime(tBuffer, 32, "%I:%M %p", localtime(&curTime_tt));
        pc.printf("...custom string format = %s\n\n", tBuffer);

        wait(waitTime); // Wait between updates.
    }
}