/*
    Project: potSerial
    File: main.cpp
    
    Reads from analog input, streams ASCII text to std serial using printf and
    lights onboard LED. Also demonstrates use of floating point literal suffix
    to eliminate warning and int constants for HIGH and LOW.
    
    Written by: Dr. C. S. Tritt
    Created: 2/8/20 (v. 1.0)
    
*/
#include "mbed.h"

const int HIGH = 1; // Optional, but makes code more readable.
const int LOW = 0; // Optional, but makes code more readable.
const float WAIT = 0.25f; // Wait time between samples (s).
const float LIGHT = 0.5f; // Analog value (0 to 1 scale) to light LED.
 
AnalogIn analog_value(A0);
 
DigitalOut led(LED1);

int main() {
    float value; // Value to be read and sent to serial port.
    
    printf("\nAnalog to serial example.\n");
    
    while(true) {
        value = analog_value.read(); // Read the analog input value (0 to 1)
        printf("%f\n", value); // Send value as text via serial port.
        if (value > LIGHT) { // Activate built-in LED based on LIGHT value.
          led.write(HIGH);
        }
        else {
          led.write(LOW);
        }
        wait(WAIT); // Wait WAIT seconds.
    }
}