/*
  Project: my_SetRTC, File: main.cpp.

  Based on mktime example: weekday calculator from
  http://www.cplusplus.com/reference/ctime/mktime. Modified to set Mbed/Nucleo
  RTC.

  Note the on the Nucleo F446RE the Nucleo the RTC survives (is not reset by) 
  device reset an even downloading new code! It is also claimed that it 
  continues to keep time even when the processor in in sleep mode.

  Modified by C. S. Tritt
  Last modified: 7/28/18 (v. 1.1)
*/
#include <mbed.h> // wait, etc.
//#include <mbed_mktime.h> // For _rtc_mktime. Didn't work.
//#include <stdio.h> // printf, scanf - incl. in mbed.h.
//#include <time.h> // time_t, struct tm, time, mktime in mbed.h.

int main ()
{
    // Announce project and program information.
    printf("\nProject: my_SetRTC, File: main.cpp (v. 1.1)\n");
    
    // Create variables.
    time_t rawtime;
    struct tm* timeinfo;
    int year, month ,day, hours, minutes, secs;
    const char* weekday[] = { "Sunday", "Monday",
                              "Tuesday", "Wednesday",
                              "Thursday", "Friday", "Saturday"
                            };

    // Get current RTC time structure.
    time(&rawtime);
    timeinfo = localtime(&rawtime); // Modify to local time.
    printf("Current RTC time: %s", ctime(&rawtime)); // Display current time.
    
    // See if user wants to reset the RTC.
    printf("\nTurn local echo on to see your input.\n");
    printf("Do you want to set new time (y or n): ");
    char userIn;
    scanf("%c", &userIn);
    if (userIn == 'y') {
        // Prompt user for date and time.
        printf("\nEnter year (YYYY): ");
        scanf ("%d",&year);
        printf("\n%d read.", year);
        printf("\nEnter month (1 to 12): ");
        scanf ("%d",&month);
        printf("\n%d read.", month);
        printf("\nEnter day (D or DD): ");
        scanf ("%d",&day);
        printf("\n%d read.", day);
        printf("\nEnter hours (0 to 23):");
        scanf ("%d",&hours);
        printf("\n%d read.", hours);
        printf("\nEnter minutes (0 to 59):");
        scanf ("%d",&minutes);
        printf("\n%d read.", minutes);
        printf("\nEnter seconds (0 to 59):");
        scanf ("%d",&secs);
        printf("\n%d read.", secs);
    
        // Modify it using user input.
        timeinfo->tm_year = year - 1900; // tm_year are from 1900.
        timeinfo->tm_mon = month - 1; // tm_month are 0 to 11.
        timeinfo->tm_mday = day;
        timeinfo->tm_hour = hours;
        timeinfo->tm_min = minutes;
        timeinfo->tm_sec = secs;
    
        // Call mktime: timeinfo->tm_wday will be set.
        mktime(timeinfo);
    
        // tm_wday are 0 to 6. Use to check entered values.
        printf("\nThis must be a %s.\n", weekday[timeinfo->tm_wday]);
    
        // Set the mbed RTC to the current time. Not interupt safe. Should be
        // _rtc_mktime, but that didn't work.
        set_time(mktime(timeinfo));
    }

    while (true) { // Loop forever more.
        // Get current time.
        time_t nowSecs = time(NULL);

        // Display it in various ways.
        printf("\nSeconds since UNIX Epoch: %d\n", nowSecs);
        printf("Time as a ctime string: %s", ctime(&nowSecs)); // String has \n.
        char buffer[32];
        strftime(buffer, 32, "%I:%M %p\n", localtime(&nowSecs));
        printf("Time as a strftime custom string: %s\n", buffer);

        // Sleep for 1 second.
        wait(1.0);
    }
}