/*
    Project: mySmrtNL_2(for My Smart Nightlight)
    File: main.cpp

    Reads from analog input, streams ASCII text to std serial using printf and
    DigitalOut control of external LEDs. Default serial configuration is 9600 
    baud, 8 data bits, no parity and 1 stop bit.

    Requires manual calibration. Enter max. and min. values below, recompile 
    and send to Nucleo board.

    Written by: Dr. C. S. Tritt
    Created: 10/7/17 (v. 2.0)

*/
#include "mbed.h"

const int HIGH = 1; // Optional, but makes code more readable.
const int LOW = 0; // Optional, but makes code more readable.

AnalogIn analog_value(A0); // Construct AnalogIn object called analog_value.

DigitalOut red(D2); // Construct DigitalOut object called red.
DigitalOut grn(D3); // Construct DigitalOut object called grn.
DigitalOut blu(D4); // Construct DigitalOut object called blu.

int main()
{
    const float v_max = 1.0f; // Change to your max. serial value.
    const float v_min = 0.0f; // Change to your min. serial value.
    const float step = (v_max - v_min)/4.0f; // Calibration step size.
    const float g_off_r_on = v_max - step; // Green off, red on value.
    const float b_off_g_on = v_max - 2.0f*step; // Blue off, green on value.
    const float b_on = v_max - 3.0f*step; // Blue on value.

    float value; // Value to be read and sent to serial port.

    printf("\nAnalogIn example\n"); // Identify program.

    while(true) {
        value = analog_value.read(); // Read the analog input value (0 to 1)
        printf("Value = %f\n", value); // Send value as text via serial port.
        if (value > g_off_r_on) { // Activate red for darkest conditions.
            red.write(HIGH);
            grn.write(LOW);
            blu.write(LOW);
        } else if (value > b_off_g_on) { // Activate green for dim light.
            red.write(LOW);
            grn.write(HIGH);
            blu.write(LOW);
        } else if (value > b_on) {// Activate blue for brighter light.
            red.write(LOW);
            grn.write(LOW);
            blu.write(HIGH);
        } else { // All junctions off for brightest light.
            red.write(LOW);
            grn.write(LOW);
            blu.write(LOW);
        }
        // Read and send LED state via serial.
        printf("RGB State: %d %d %d\n", red.read(), grn.read(), blu.read());
        wait(0.5); // Half a second (500 mS).
    }
}