/*
  Blink -   Turns on an LED on and off for, repeatedly.
  Last Revised: 9/11/21 (v. 1.0)
  Based on mbed example. Modified by Dr. C. S. Tritt. This example code is in 
  the public domain. 
*/
//  #include is a directive that "pastes" a file into your code.
//  Use this specific #include at the beginning of each mbed program.
//  mbed.h contains/points to the full definitions of our simple statements.
#include "mbed.h"
//  Define the object board_LED to be a digital output connected to LED1,
//  which is the little green LED built into the Nucleo board.
DigitalOut board_LED(LED1);
float waitOn = 1.4f; // On time in seconds. All variables must be declared.
float waitOff = 0.6f; // Off time in seconds. The f indicates float type.
/*  
    The "main" function defines your main program -- it executes as soon as
    you program the board. Functions can return (compute and give back) a 
    value.  The main function could return an integer error code, so it begins 
    with int. Functions can also accept inputs.  The main function cannot 
    however, so its round parentheses are empty.
*/  
int main() { // This curly brace marks the beginning of the main function.
    // while() will repeat a set of actions as long as the statement inside
    // its round parentheses is true. 1 is the definition of true, so
    // while(1) and while(true) repeat forever. 
    while(true) {   // This curly brace marks the start of the repeated actions.
        board_LED = 1;  // Turn on LED by storing a 1 in board_LED.
        wait(waitOn);      // wait(x) will pause for a given number of seconds.
        board_LED = 0;  // Turn off LED by storing a 0 in board_LED.
        wait(waitOff);      // wait another 1/2 second.
    }  // end of repeated actions  
}  // end of main function