/*
    Project: analogRead_u16
    File: main.cpp

    Reads from analog input, streams ASCII text to std serial using printf and
    lights onboard LED. Also demonstrates use of integer literal suffixes 
    and constants for HIGH and LOW.

    Written by: Dr. C. S. Tritt
    Created: 3/26/17 (v. 1.0)

*/
#include "mbed.h"

const int HIGH = 1; // Optional, but makes code more readable.
const int LOW = 0; // Optional, but makes code more readable.

AnalogIn analog_value(A0);

DigitalOut led(LED1);

int main()
{
    uint16_t iValue; // Value to be read. Must be unsigned int 16.

    printf("\nAnalogIn example\n");

    while(true) {
        iValue = analog_value.read_u16(); // Read analog value as uint16.
        printf("Value = %u\n", iValue); // Unsigned (u) specifier required.
        if (iValue > 32768u) { // Activate built-in LED. The u is required.
            led = HIGH;
        } else {
            led = LOW;
        }
        wait(0.25); // 250 ms
    }
}
