/*
    Project: analogRead_Overloads
    File: main.cpp
    
    Reads from analog input, streams ASCII text to std serial using printf, and
    lights onboard LED. Also demonstrates use of floating point literal sufix to 
    eliminate warning and int constants for HIGH and LOW. This version uses
    overloaded operators and sends LED state read from DigitalOut object.
    
    Written by: Dr. C. S. Tritt
    Created: 3/26/17 (v. 1.0)
    
*/
#include "mbed.h"

const int HIGH = 1; // Optional, but makes code more readable.
const int LOW = 0; // Optional, but makes code more readable.
 
AnalogIn analog_value(A0);
 
DigitalOut led(LED1);

int main() {
    float value; // Value to be read and sent to serial port.
    
    printf("\nAnalogIn example\n");
    
    while(true) {
        value = analog_value; // Read the analog input value (0 to 1)
        printf("Value = %f\n", value); // Send value as text via serial port.
        if (value > 0.5f) { // Activate built-in LED. The f is optional.
          led = HIGH;
        }
        else {
          led = LOW;
        }
        printf("LED = %d\n", (int) led); // Send LED state as serial text.    
        wait(0.25); // 250 ms
    }
}