/*
    Project: analog2pwm
    File: main.cpp

    Reads from analog input, streams ASCII text to std serial using printf and
    and proportionally lights onboard LED. Also demonstrates floating point 
    literal sufix to eliminate warning.

    Written by: Dr. C. S. Tritt
    Created: 3/27/17 (v. 1.0)
    Last revised: 5/8/18 (ported to CE Dev Board)

*/
#include "mbed.h"

AnalogIn analog_value(A5); // A5 is unused on CE Dev Board.

PwmOut led(LED1); // D13 on Nucleo boards.

int main()
{
    float value; // Value to be read and sent to serial port.

    printf("\nAnalog to PWM example.\n");

    while(true) {
        value = analog_value.read(); // Read the analog input value (0 to 1)
        printf("Value = %f\n", value); // Send value as text via serial port.
        led.write(value); // Proportionally light LED.
        wait(0.25); // 250 ms
    }
}
