/*
    Project: aReadConditional (for analog read conditional)
    File: main.cpp
    
    Reads from analog input, streams ASCII text to std serial using printf and
    lights onboard LED. Also demonstrates use of floating point literal suffix
    toeliminate warning and int constants for HIGH and LOW.
    
    Written by: Dr. C. S. Tritt
    Created: 3/27/17 (v. 1.1)
    
*/
#include "mbed.h"

const int HIGH = 1; // Optional, but makes code more readable.
const int LOW = 0; // Optional, but makes code more readable.
 
AnalogIn analog_value(A0); // Construct AnalogIn object called analog_value.
 
DigitalOut led(LED1); // Construct DigitalOut object called led.

int main() {
    float value; // Value to be read and sent to serial port.
    
    printf("\nAnalogIn example\n"); // Identify program.
    
    while(true) {
        value = analog_value.read(); // Read the analog input value (0 to 1)
        printf("Value = %f\n", value); // Send value as text via serial port.
        if (value > 0.5f) { // Activate built-in LED. The f is optional.
          led.write(HIGH);
        }
        else {
          led.write(LOW);
        }
        printf("LED = %d\n", (int) led.read()); // Send LED state via serial. 
        wait(0.5); // Half a second (500 mS).
    }
}
