/*
Project: WhatTime
File: main.cpp
 
Uses a timer to display the interval between button press and release.
 
Created 12 Aug 2017 by Sheila Ross
Last modified 9/17/17 by C. S. Tritt
*/
#include "mbed.h"
 
// Construct a USER_BUTTON digital input.
DigitalIn myButton(USER_BUTTON);
 
// Construct a timer object.
Timer myTimer;
 
// Construct a transmit only serial connection over our USB.
Serial pc(USBTX, NC, 9600);
 
 
int main()
{
    myTimer.start();  // Start the timer.
 
    while(true) { // Main loop.
        if (myButton == 0) { // Button is pressed (active low).
            // Save the time on timer.
            float current_time = myTimer.read();
                     
            // Send the time as text via the serial port.
            pc.printf("Time difference %f seconds.\n",current_time );
            
             // Reset the timer.
            myTimer.reset();
                     
            // Wait for the user to release the button.
            while(myButton == 0) {
            }
        }
    }
}