/*
  Project: WaitTest
  File: main.cpp
  Modified by by: Dr. C. S. Tritt
  Last revision on: 9/27/17 (v. 1.0)

  Demonstrate/confirm wait function behaivor
*/
#include "mbed.h"

Ticker myTicker; // My ticker object. Used to generate output.

// Declare my ticker callback function. Sends text to serial.
void tick_Callback(void);

int main() {
    // Setup to call to_Callback once a second.
    myTicker.attach(&tick_Callback, 1.0);
    wait(0.5); // Offset main loop calls by half a second.
    int mainCount = 0; // Main loop counter.
    while (true) {
        // Tested a wait of 0. It was not taken as infinity.
        wait(1.0); // Cycle this loop once a second.
        mainCount++; // Increment mainCount.
        if (mainCount == 11) mainCount = 1; // Reset every 10 times.
        printf("In main loop. Count = %d.\n", mainCount);
    }
}

// Define my ticker callback function. Sends text to serial.
void tick_Callback(void) {
    static int cbCount = 0; // Initialized on load. Remembered between calls.
    cbCount++; // Increment call back counter.
    if (cbCount == 11) cbCount = 1; // Reset every 10 times.
    // Note: printf should not be used in interrupt style callbacks!
    printf("In ticker callback loop. Count = %d.\n", cbCount);
}