/*
Project: TimerTest2
File: main.cpp
 
Tests timer peformance. Display new time difference with each button press
and release. Differences of 1 or 2 microseconds are typical.

Last modified 9/17/17 by C. S. Tritt (v. 1.0)
*/
#include "mbed.h"
 
// Construct a USER_BUTTON digital input.
DigitalIn myButton(USER_BUTTON);
 
// Construct a timer object.
Timer myTimer;
 
// Construct a transmit only serial connection over our USB.
Serial pc(USBTX, NC, 9600);
 
int main()
{
    myTimer.start();  // Start the timer.
 
    while(true) { // Main loop.
        if (myButton == 0) { // Button is pressed (active low).
            // Save the time on timer.
            int firstTime = myTimer.read_us();
            int secondTime = myTimer.read_us();
                     
            // Send the time as text via the serial port.
            pc.printf("Time difference %i microseconds.\n", secondTime - 
                firstTime );
            
             // Reset the timer.
            myTimer.reset();
                     
            // Wait for the user to release the button.
            while(myButton == 0) {
            }
        }
    }
}