/*
    Project: TimeoutEX
    File: main.cpp
    
    Button interrupt sets global config flag. Timeout clears it. Them main 
    program flashes red or green LED based on config status.
    
    Created by Dr. C. S. Tritt
    Last revised: 10/9/17 (v. 1.1)
*/
#include "mbed.h"

void buttonISR(); // Button ISR declaration.
void configOff(); // Configuration mode off declaration.
 
InterruptIn myButton(USER_BUTTON); // Button is normally high. Goes low w/press.
Timeout configTime; // TimeOut constructor takes no arguments.

DigitalOut redLED(D2); // Red and green LED junctions.
DigitalOut grnLED(D3);

bool config = false; // Configuration mode flag.

int main() {
    redLED = 0; // Turn red & green off at start.
    grnLED = 0; 
    
    myButton.fall(&buttonISR); // Register ISR routine.
 
    while(true) { // Main loop.
        if (config) {
            redLED = !redLED; // Toggle red junction.
        } else {
            grnLED = !grnLED; // Toggle green junction.
        }
        wait(0.5); // Pause half a second.
    }
}

void buttonISR() { // Sets config status when button falls.
    config = true; // Set config status.
    grnLED = 0; // Force green junction off.
    redLED = 1; // Turn red junction on.
    configTime.attach(&configOff, 5.0f); // Register callback. 5 sec. delay.
}

void configOff() { // Clears config flag after timeout.
    config = false; // Clear config flag.
    redLED = 0; // Force red junction off.
    grnLED = 1; // Turn green junction on.
}