/*
  Project: TimeTests
  File: main.cpp
  Modified by by: Dr. C. S. Tritt
  Last revision on: 9/28/17 (v. 1.0)

  Experiments with time features of Nucleo boards. This millis timer reproduces
  the Ardunio millis() function. It rolls over after 49.7 days. Responds to 
  serial characters by displaying millis and delta millis.

  Note: The C time.h functions compile, but do not appear to return anything.
*/
#include "mbed.h"

volatile unsigned int millis = 0; // Global millisecond counter.

Ticker milliTick; // Ticker to add milliseconds to millis.
Serial pc(USBTX, USBRX); // Serial connection to PC.

void milliIncr(void); // Callback that adds millisconds to millis.

int main()
{
    unsigned int oldT; // Previous time value.
    unsigned int newT; // Current time value.
    milliTick.attach_us(milliIncr, 1000); // Adds milliseconds to millis.
    while(true) {
        if (pc.readable()) {
            pc.putc(pc.getc()); // echo character(s).
            oldT = newT;
            newT = millis;
            printf("\nt & Delta t: %u and %u.\n", newT, newT - oldT);
        }
        wait(0.2); // Poll port every 200 mS. About 28 mS loop time.
    }
}

void milliIncr(void) // Call back that adds millisconds to millis.
{
    millis++; // Increment by 10 milliseconds each time.
}