/*
    Project: TW_Ex_9_9
    File: main.cpp

    An example similar to T&W example 9.9. imple demo of "Ticker". Replicates 
    behaviour of first led flashing program.

    Modified by Dr. C. S. Tritt
    Last revised: 10/8/17 (v. 1.0)
*/

#include "mbed.h"

void led_switch(void); // Ticker callback declaration.
Ticker time_up; // Define a Ticker named "time_up."
DigitalOut myled(D4); // Blue LED junction.

int main(){
    time_up.attach(&led_switch, 0.2); // Initialize Ticker. 0.2 s interval.
    while(1) {} // Sit in a loop doing nothing, waiting for Ticker interrupt.
}

void led_switch() {  // Ticker callback.
    myled=!myled;
}