/*
    Project: SevenSegLookup
    File: main.cpp

    Counts through the digits 0 to 9 on the 7-segment display.
    
    See external documentation for pin connections (very important).

    Written by: Dr. C. S. Tritt
    Created: 9/26/17 (v. 1.0)

*/
#include "mbed.h"

BusOut ssDisplay(D10, D9, D8, D7, D6, D5, D4, D3); // Display segments

int main()
{
    // Declare and initialize array in one step.
    int Segments[] 
    {0x81, 0xCF,0x92,0x85,0xCC,0x4A,0xE1, 0xCE,0x80,0x84, 0x7F};

    while(true) { // Loop forever.
        for (int i; i <= 9; i++) { // Cycle through digits.
            ssDisplay = Segments[i]; // Display current digit.
            wait(1.0); // Wait a second, then repeat.
        }
    }
}