/* 
    Project: SerialRelay
    File: main.cpp
    Created by: Dr. C. S. Tritt
    Last revised: 11/8/17
    
    Relays serial data from PC to Nucleo Serial3 (PC_10 for TX, PC_11 for RX).
    
    Tera Term configurations
    Terminal - New-line, Receive LF, Transmit LF
    Serial port - Data 8 bit, Parity none, Stop 1 bit, Flow control none.
    Baud as specified below.
*/
#include "mbed.h"

//------------------------------------

//------------------------------------

Serial pc(USBTX, USBRX, 9600); // Standard to PC via USB channel.
Serial bc(PC_10, PC_11, 9600); // Serial3. Pins at top of left Morphio header.

DigitalOut actLED(LED1); // Activity toggle.

int main()
{
    while (true) {
        if (pc.readable()) {
            char character = (char) pc.getc();
            //pc.putc(character);
            bc.putc(character);
            actLED = !actLED;
        }
        if (bc.readable()) {
            char character = (char) bc.getc();
            //bc.putc(character);
            pc.putc(character);
            actLED = !actLED;
        }
    }
}