/* 
    Project: SerialEcho
    File: main.cpp
    Created by: Dr. C. S. Tritt
    Last revised: 1/17/19 (v. 1.0)
    
    Receives serial data from PC to and echos it back, character for character.
    
    Tera Term configurations
    Terminal - New-line, Receive LF, Transmit LF
    Serial port - Data 8 bit, Parity none, Stop 1 bit, Flow control none.
    Baud as specified below.
*/
#include "mbed.h"

Serial pc(USBTX, USBRX, 9600); // Standard to PC via USB channel.

DigitalOut actLED(LED1); // Activity LED.

int main()
{
    while (true) {
        if (pc.readable()) {
            char character = (char) pc.getc(); // Get a char from the PC.
            pc.putc(character); // Send it back to the PC.
            actLED = !actLED; // Toggle the activity LED.
        }
    }
}