#include "mbed.h"
/*
    Serial2RGB main by C. S. Tritt, Last revised 3/18/17 (v. 1.1)
    
    Toggles RGB LED junctions in response to serial input. Echos input.
    
    Suggested wiring...
    
    Common Anode LED (active low)
    
                           /-- 1 kΩ -- D9 (red)
    + 3.3 to 5.0 V ----LED<--- 680 Ω -- D10 (green)
                           \-- 680 Ω -- D11 (blue)
    
    Common Cathode LED (active high)
    
                /-- 1 kΩ -- D9 (red)
    GND ----LED<--- 680 Ω -- D10 (green)
                \-- 680 Ω -- D11 (blue)
   
*/
DigitalOut RedLED(D9); // Physically same as Arduino Digital pin 9 on Nucleos.
DigitalOut GrnLED(D10); // Physically same as Arduino Digital pin 10.
DigitalOut BluLED(D11); // Physically same as Arduino Digital pin 11.

Serial pc(USBTX, USBRX); // Default settings are 9600 Baud, 8-N-1.

int main() {
    
    RedLED = 0;
    GrnLED = 0;
    BluLED = 0;
    char letter;
    
    while(true) {
        if (pc.readable()) {
            letter = pc.getc();
            pc.putc(letter);
            if (letter == 'r') {
                RedLED = !RedLED;
            }
            else if (letter == 'g') {
                GrnLED = !GrnLED;
            }       
            else if (letter == 'b') {
                BluLED = !BluLED;
            }       
        }
    }
}