/*
    Serial2RGB main by C. S. Tritt, Last revised 9/15/21 (v. 1.3)

    Toggles RGB LED junctions in response to serial input. Note input is case 
    sensive and known "commands" are r (toggle red), g (toggle green) and b 
    toggle blue). Input (including CR/LF is echoed.
    
    Mbed 5 or earlier (due to Serial, BufferedSerial changes).
    
    Suggested wiring...

    Common Anode LED (active low)

                           /-- 680 kΩ -- D13 (red)
    + 3.3 to 5.0 V ----LED<--- 680 Ω -- D14 (green)
                           \-- 1 kΩ -- D15 (blue)

    Common Cathode LED (active high)

                /-- 680 Ω -- D13 (red)
    GND ----LED<--- 680 Ω -- D14 (green)
                \-- 1 kΩ -- D15 (blue)

*/

// Include mbed API/Library declarations.
#include "mbed.h"

// Construct resources (these are global).

DigitalOut RedLED(D13); // Arduino Digital pin 13 on Nucleos.
DigitalOut GrnLED(D14); // Arduino Digital pin 14.
DigitalOut BluLED(D15); // Arduino Digital pin 15.

Serial pc(USBTX, USBRX); // Default settings are 9600 Baud, 8-N-1.

int main()
{

    RedLED = 0;  // Set pins to known state. This may be the default.
    GrnLED = 0;
    BluLED = 0;
    char letter;  // Declare a local variable to hold recieved characters.

    while(true) {  // Main (infinite) loop.
        if (pc.readable()) {  // Is there a character waiting? If so,
            letter = pc.getc();  // Get it.
            pc.putc(letter);  // Echo it to the terminal.
            if (letter == 'r') {  // Respond to known letters, ignore others.
                RedLED = !RedLED;  // Toggle red.
            } else if (letter == 'g') {
                GrnLED = !GrnLED;  // Toggle green.
            } else if (letter == 'b') {
                BluLED = !BluLED;  // Toggle blue.
            }
        }
    }
}