/*
    Project: PullTest
    File: main.cpp
    
    For exploring pull up, pull down and pull none behavior of F446RE boards. 
    Makes D2-4 pull-up, D5-7 pull-down, and D8-10 pull-none. Test currents to 
    power and ground to determine internal resistance. D11 used to check 
    default operation (should be PullNone)
    
    Written by: Dr. C. S. Tritt
    Created: 3/27/17 (v. 1.1)
    
*/
#include "mbed.h"

DigitalIn myD2(D2, PullDown); // D2-4 and D5-7 reversed.
DigitalIn myD3(D3, PullDown);
DigitalIn myD4(D4, PullDown);
DigitalIn myD5(D5, PullUp);
DigitalIn myD6(D6, PullUp);
DigitalIn myD7(D7, PullUp);
DigitalIn myD8(D8, PullNone);
DigitalIn myD9(D9, PullNone);
DigitalIn myD10(D10, PullNone);
DigitalIn myD11(D11);

int main() {
    printf("\nPull Tests\n");
    
    while(true) {
        // Send D_In statuses. Casts to avoid non-POD type passed warnings.
        printf("Ds = %d %d %d %d %d %d %d %d %d %d.\n",
         (int) myD2, (int) myD3, (int) myD4, (int) myD5, (int) myD6, 
         (int) myD7, (int) myD8, (int) myD9, (int) myD10, (int) myD11); 
        wait(0.5); // 500 ms
    }
}
