/*
    Project: PowOf3
    File: main.cpp
    
    Simple powers of 3 program. Demonstrates for loops and arrays.
  
    Written by: Dr. C. S. Tritt
    Created: 9/25/17 (v. 1.0)
    
*/
#include "mbed.h"

Serial pc(USBTX, NC, 9600); // Serial transmit only @ 9600 baud.
AnalogIn analog_value(A0); // Construct AnalogIn object called analog_value.

int main() {
     
    printf("\nPowers of 3 Demonstration (v. 1.0)\n"); // Identify program.
    
    const int SIZE = 10; // Number of array elements.
    
    int i; // Loop counter.
    int p[SIZE]; // Number of elements.
    
    for(i = 0; i <= SIZE - 1; i++) {
        p[i] = (int) pow(3.0, (double) i);
        pc.printf(" i = %i and 3^i = %i.\n", i, p[i]);
    }
}