/*
    Project: PointerScanf
    File: main.cpp
    Revised by Dr. C. S. Tritt
    11/3/17
    
    Use a pointer, rather than a reference in scanf. Based on a Horton, 
    Chapter 7 example.
*/
#include "mbed.h"

// Use an explicit Serial object (as opposed to the implicit one) for a change
// of pace...
Serial pc(USBTX, USBRX); 

int main(void)
{
  int value = 0;
  int *pValue = &value; // Set pointer to refer to value.
  pc.printf ("\nTurn local echo on.\n");
  pc.printf ("Enter an integer: ");
  pc.scanf(" %d", pValue); // Read into value via the pointer.
  pc.printf("You entered %d (base 10).\n", value); // Display the value entered.
  pc.printf("Which is %x (base 16).\n", value); // Display the value entered.
  pc.printf("Done. Now I sleep.\n");
  while (true) wait(3600.0f);
}