/*
    Project: PointerPlay
    File: main.cpp

    Demonstrates some uses of pointers.

    Written by: Dr. C. S. Tritt
    Created: 11/4/21 (v. 1.1)

*/
#include "mbed.h"
Serial pc(USBTX, USBRX, 9600); // Explicitly create serial connection.

int main() {
    printf("\nPointer Play -- \"a is a.\"\n");
    // Each set of lines below create a variable and a pointter to it.
    float myNum1 = 1.23f; // Initialize the variable.
    float* pNum1 = &myNum1; // Initialize the pointer to point to it.
    printf("myNum1 is %f and *pNum1 is %f.\n", myNum1, *pNum1);
    int myNum2; // Create a variable.
    int* pNum2 = NULL; // Create a NULL (unassigned) pointer.
    pNum2 = &myNum2; // Put the address in the pointer.
    *pNum2 = 15; // Dereference the pointer to store a value.
    pc.printf("myNum2 is %d and *pNum2 is %d.\n", myNum2, *pNum2);
    // Examine the addresses (pointer values).
    pc.printf("pNum1 is %p and pNum2 is %p.\n", pNum1, pNum2);
    while(true); // Wait here forever.
}