/*
   Project: PatientStructure
   File: patients.h (v. 1.0)
   
   Header file for patient data base using structure example. See main.cpp
   for details.
   
   Modified by Dr. C. S. Tritt
*/
// Defined in main. Used in main & patients.cpp, so declare in header file. 
// extern is rerequied to avoid duplicate objects that result in a linker
// error.
extern Serial pc;

// The patient_record structure stores name and vitals for a patient.
struct patient_record {
    char firstname[30];
    char lastname[30];
    int systolic;
    int diastolic;
    float spO2;
};

// It is assumed that we will have an array of these patient records.
// We define the maximum number of patients that we will support.
#define MAX_PATIENTS 100

//Print the values in the structure for a particular patient.
void print_patient_record(struct patient_record *first_patient, int N);
//Put patient into record.
void newPatient(struct patient_record *patient,  char *first, char*last);
//Fill in vital signs directly.  Note that we use -> when we have a
//pointer to a struct and we want to access one of the members.
void recordBP(struct patient_record *patient, int sys, int dias, float o2); 
//Fill in vital signs through the serial monitor (for BP) and the oxygen sensor,
//assumed to be an analog input giving the SpO2 level as a fraction.
void recordBPinteractive(struct patient_record *first_patient, AnalogIn oxygen);
//Look up the patient number by searching through the array of patients
//and matching the first and last name.  strcmp returns 0 if two strings
//are identical.  Return the patient's position in the array if name is
//found, -1 if it is not found.
int lookup_patient_name(struct patient_record *first_patient, char*first,
    char*last);