/*
  Project: PatientStructure (based on very similar example by Dr. Ross.)
  File: main.cpp (file v. 1.0)
  Modified by by: Dr. C. S. Tritt
  Last revision on: 11/2/17 (Project v. 1.0)

  Simulates a patient database. See comments in patients.cpp regarding purpose 
  use of each function. This function just populates the database and initates 
  update of one record.
  
  This program is for demonstration only. Input is not validated and array 
  limits are not checked. This is bad programming practice, but okay for "toy"
  programs like this.
*/

#include "mbed.h"
#include "patients.h"

// Some functions use the serial monitor so define it here. Declare as extern
// in header file.
Serial pc(USBTX,USBRX);

//Pretend we have a pulse oximeter attached to A0 which provides the SpO2
//as a fraction.
AnalogIn pulse_oximeter(A0);

int main()
{
    pc.printf("\nWelcome to PatientStructure Example.\n");
    pc.printf("Turn local echo on!\n");
    // Create an array of patient_record structures to form the patient 
    // database.
    pc.printf("About to create and populate database...\n");
    struct patient_record all_patients[MAX_PATIENTS];
    // Keep track of the number of patients.
    int enrollment=0;
    
    //Add patient info.
    newPatient(&(all_patients[enrollment]),"George","Washington");
    enrollment++;

    newPatient(&(all_patients[enrollment]),"John","Adams");
    enrollment++;
    
    newPatient(&(all_patients[enrollment]),"Thomas","Jefferson");
    enrollment++; // Enrollment incr. an extra time. Its the # of pateints.

    //Look up a patient -- this one is not in our database.  
    pc.printf("About to lookup non-existent patient...\n");  
    int X = lookup_patient_name(all_patients, "Abraham", "Lincoln");
    pc.printf("Abraham Lincoln is patient %d\n", X);
    
    //Look up a patient.    
    pc.printf("About to lookup valid patient...\n");  
    int Y = lookup_patient_name(all_patients, "Thomas", "Jefferson");
    pc.printf("Thomas Jefferson is patient %d\n", Y);
   
    //Enter patient's vitals.
    pc.printf("About to interactively update patient data...\n");
    pc.printf("There are %d patients in the database. Be careful!\n", 
        enrollment);  
    recordBPinteractive(all_patients, pulse_oximeter);
    
    pc.printf("Done. I sleep now...\n");  
    while(true) wait(3600); // Loop here forever, waiting an hour at a time.
}