/*
  Project: PatientCounterMain
  File: main.cpp
 
 Counts patients entering a leaving a waiting room. This version uses fuctions 
 that would otherwise be linked to interrupts. 
 
 The circuit:
 
    Bargraph LEDs from pins 2 through 11 to ground via 330 Ohm resistors.
    Pushbuttons between pins D14 & 15 and ground (internal pullup resistors 
    used.
 
 Created by C. S. Tritt 9/21/17 (v. 1.0)
 
This example code is in the public domain.
*/
 
#include "mbed.h"
 
BusOut bar_graph(D2,D3,D4,D5,D6,D7,D8,D9,D10,D11);

DigitalIn entered(D12, PullUp);
DigitalIn left(D13, PullUp);

int count = 0;

void countUp(void) {
    count++;
    printf("Counting up: %d.\n", count);
}

void countDown(void) {
    if (count > 0) count--;
    printf("Counting up: %d.\n", count);
}
 
int main() {
    while(true) { // Keep the lights going back and forth forever.
 
        if (!entered) { // Account for entries.
            while (!entered); // Wait for button release.
            countUp();
        }
        if (!left) {  // Account for departures.
            while (!left); // Wait for button release.
            countDown();
        }
        // Send count to console.
        printf("Count: %d, Entered: %d, Left: %d.\n", count, (int) entered, 
            (int) left);
        bar_graph = count; // Show count on bar.
        wait(0.05); // Pause.
    }
}