/*
  Project: PatientCounterIntrp
  File: main.cpp
 
 Demonstrates the use of interupts to count patients entering a leaving a 
 waiting room. However, button bounce appears to make this approach leads to 
 bounce.
 
 The circuit:
 
    Bargraph LEDs from pins 2 through 11 to ground via 330 Ohm resistors.
    Pushbuttons between pins D14 & 15 and ground (internal pullup resistors 
    used.
 
 Created by C. S. Tritt 9/21/17 (v. 1.0)
 
This example code is in the public domain.
*/
 
#include "mbed.h"
 
BusOut bar_graph(D2,D3,D4,D5,D6,D7,D8,D9,D10,D11);

InterruptIn inSensor(D12);
InterruptIn outSensor(D13);

int count = 0;

void countUp(void) {
    count++;
}

void countDown(void) {
     if (count > 0) count--;
}
 
int main() {

    inSensor.fall(&countUp);
    outSensor.fall(&countDown);

    while(true) { // Keep the lights going back and forth forever.
 
        bar_graph = count; // Show count on bar.
        // Send count to console.
        printf("Count: %d.\n", count); 
        wait(0.5); // Pause.
    }
}