/*
    Project: PWM_Driver_Serial
    File: main.cpp
    
    Reads from analog input, sends to PWM, streams ASCII text to std serial 
    using printf. Use to test higher voltage and current transistor driver 
    circuits.
    
    Written by: Dr. C. S. Tritt
    Created: 5/12/20 (v. 1.0)
    
*/
#include "mbed.h"

const float WAIT = 0.5f; // Wait time between samples (s).
 
AnalogIn myAIn(A0); // Analog input, connect to pot V divider.
PwmOut myPWM(D10); // PWM output, Bargraph bit 1, connect to driver.
 
DigitalOut led(LED1);

int main() {
    float value; // Value to be read and sent to serial port.
    
    printf("\nAnalog to serial & PWM example.\n");
    
    while(true) {
        value = myAIn.read(); // Read the analog input value (0 to 1)
        myPWM.write(value); // Write value read to PWM pin.
        printf("%f\n", value); // Send value as text via serial port.
        wait(WAIT); // Wait WAIT seconds.
    }
}