/*
  Project: NoHeaderTest
  File: main.cpp
  Last revised by: Dr. C. S. Tritt
  Last revision on: 9/19/17 (v. 1.0)
  
  Repeatedly toggles on-board LED. Demonstrates single file project approach.
 
  This example code is in the public domain.
*/
// Use #include directives to "paste" text from other files into your code.
// Use this #include to declare all the mbed driver classes. The mbed library 
// must also be added to the project either by importing it or by "Fixing" the
// error that is generated when it has not been imported.
#include "mbed.h"

// Mbed driver class objects are typically declared and defined as global.
DigitalOut board_LED(LED1);

const float BASE_WAIT = 0.1;
int cycles = 1;

void myStuff(void); // Declared here, defined after main.

/*  The "main" function defines your main program -- it executes as soon as
    you program the board.
*/  
int main() {   // This curly brace marks the beginning of the main function.
    board_LED = 0; // Initialize LED state (not necessary in this case).
    while(true) { // while(true) repeat forever. 
        myStuff(); // Call function that is in its own file.
        if (cycles == 11) { // Reset cycles after 10 of them.
            cycles = 1;
        }
    }
}

void myStuff(void) {
    board_LED = !board_LED; // Toggle LED state.
    wait(BASE_WAIT * (float) cycles); // Wait varying intervals.
    cycles++; // Slowly slow down flash rate.
}