/*
    Project: Nightlight2
    File: main.cpp
    
    See Word document.
    
    Written by: Dr. C. S. Tritt
    Created: 3/26/17 (v. 1.0)
    
*/
#include "mbed.h"

const int HIGH = 1; // Inclusion is optional, but makes code more readable.
const int LOW = 0; // Inclusion is optional, but makes code more readable.

const float br_min = 0.070; // Read from serial stream and enter.
const float br_max = 0.430; // Read from serial stream and enter.
const float k_1 = 0.7; // These values work well...
const float k_2 = 0.5;
const float k_3 = 0.3;
const float all_off = br_min + k_1*(br_max - br_min); // Thresholds... All off.
const float blu_grn = br_min + k_2*(br_max - br_min); // Blue-green fade.
const float grn_red = br_min + k_3*(br_max - br_min); // Green-red fade.
 
AnalogIn photocell(A1); // Create object for photocell.
PwmOut red(D9), grn(D10), blu(D11); // Create objects for LED connected pins.

int main() {
    float brightness; // 0 to 1 max. range. Larger indicates brighter light.
    
    printf("\nSmart nightlight example\n"); // ID software.
    
    while(true) {
        brightness = photocell; // Read light level (0 to 1).
        printf("Value = %f\n", brightness); // Send as text via serial port.
        if (brightness > all_off) { // Bright light. All LEDs off.
          red = LOW;
          grn = LOW;
          blu = LOW;
        }
        else if (brightness > blu_grn) { // Blue to green fade.
          red = LOW;
          grn = (all_off - brightness)/(all_off - blu_grn);
          blu = 1.0f - grn;
        }
        else if (brightness > grn_red) { // Green to red fade.
          red = (blu_grn - brightness)/(blu_grn - grn_red);
          grn = 1.0f - red;
          blu = LOW;
        }
        else { // Red on full intensity.
          red = HIGH;
          grn = LOW;
          blu = LOW;            
        }
        wait(0.1); // Delay 100 ms
    }
}