/*
Program: H_Bridge
Created by: Dr. C. S. Tritt
Last revised: 5/4/21 (v. 1.0)

This program controls a motor by way of an L293 H-brige chip using two buttons. 
Either switch starts the motor rotating in the respective direction when the 
motor is stopped. Either switch activiated while the motor is running stops it.

Set terminal program to send/receive LF only for new lines.

mbed Microcontroller Library
Copyright (c) 2019 ARM Limited
SPDX-License-Identifier: Apache-2.0
 */

#include "mbed.h"
#include "platform/mbed_thread.h"
#include <cstdio>

// Blinking rate in milliseconds
#define PAUSE_MS 50

DigitalInOut SW1(D2); // Switch 1, CW toogle.
DigitalInOut SW2(D12); // Switch 2, CCW toogle.
DigitalOut mPower(D10); // Indicates motor power.
DigitalOut C(D4); // Output C to L293.
DigitalOut D(D6); // Output D to L293.

int main()
{
    printf("H-Bridge by Dr. C. S. Tritt.");

    // Set pulldown resistors for switches.
    SW1.mode(PullDown); // Set pulldown resistor.
    SW2.mode(PullDown); // Set pulldown resistor.

    // Initialize local variables.
    C = 0; // Start with buffers off.
    D = 0; // Start with buffers off.
    mPower = 0; // Start with motor off. Redundant with rnng.
    bool rnng = 0; // Running flag: 0 - stopped, 1 - running.
    bool rttn = 0; // Rotation: 0 - CW, 1 - CCW.

    while (true) { // Loop forever.
        if(SW1) {
            if (rnng) {
                C = 0; // Buffers low (off).
                D = 0; // Buffers low (off).
                rnng = 0; // Stop motor.
                mPower = 0; // Deactivate light.
                printf("Stopped by SW1.\n");
            } else {
                D = 0; // Buffer low. Note low before high.
                C = 1; // Buffer high.
                rttn = 0; // Set rotation (CW).
                mPower = 1; // Activate light.
                rnng = 1; // Start motor.
                printf("CW (SW1).\n");
            }
        }
        while(SW1) thread_sleep_for(PAUSE_MS); // Wait here for SW1 release.

        if(SW2) {
            if (rnng) {
                C = 0; // Buffers low (off).
                D = 0; // Buffers low (off).
                rnng = 0; // Stop motor.
                mPower = 0; // Deactivate light.
                printf("Stopped by SW2.\n");
            } else {
                C = 0; // Buffer low. Note low before high.
                D = 1; // Buffer high.
                rttn = 1; // Set rotation (CCW).
                mPower = 1; // Activate light.
                rnng = 1; // Start motor.
                printf("CCW (SW2).\n");
            }
        }
        while(SW2) thread_sleep_for(PAUSE_MS); // Wait here for SW2 release.

        thread_sleep_for(PAUSE_MS); // Sleep between button checks.
    }
}