/*
    Project: GradeAverage
    File: main.cpp
    Ported to mbed/Nucleo by: Dr. C. S. Tritt
    Last revised: 10/22/17 (v. 1.0)
    
    Program 5.3 Averaging grades - from Beginning C, 5th ed. Ivor Horton. 
    
*/
#include "mbed.h"

const int SIZE = 5; // This is the number of grades.

int main(void)
{
    float grades[SIZE]; // Create array for storing values.
    float sum = 0.0f; // Initialize running sum of grades.

    printf("\nAssure Terminal > local echo is on.\n");
    printf("\nEnter five grades (1 at a time):\n");    // Prompt for the input.

    // Read the ten numbers to be averaged
    for(unsigned int i = 0 ; i < SIZE ; ++i) {
        printf("%2u> ", i + 1); // Display a prompt.
        // Read a grade. Danger. Always guard against array overflow on input.
        scanf("%f", &grades[i]); // Read ith value. Pass by reference.
        sum += grades[i]; // Keep a running sum.
    }
    // Calculate the average. Cast is optional.
    float average = sum / (float) SIZE;  
    printf("\nThe average of the entered grades is: %.2f\n", average);
    while (true) {} // Loop forever when done. Reset to start over.
}