/*
Project: Global Example
File: main.cpp

 This simple program demonstrates C global variables with file scope.
 See http://ascii-table.com/ansi-escape-sequences-vt-100.php for sequences.
 
 Written by: Dr. C. S. Tritt; Last revised 10/4/17 (v. 1.0)
*/
#include "mbed.h"

int myFunc(int x, int y); // Function declaration required.

const float myFactor = 3.3; // Arbitrary factor. Unitless. Move around.
const char ESC=27; // Define escape character for escape sequence.

int main() {
    while(true) {
        printf("%c[2J", ESC); // Optional - ANSI/VT100 clear screen sequence.
        printf("%c[H", ESC); // Optional - ANSI/VT100 cursor home.
        printf("In function demo main...\n");        
        int a = 5; // Create and initialize a.
        printf("a = %d\n", a); // Display a.
        int b = 6; // Create and initialize b.
        printf("b = %d\n", b); // Display b.
        printf("About to call my function.\n");
        int c = myFunc(a, b); // Call my function.
        printf("Function has returned.\n");
        printf("c = %d\n", c); // Display b.
        wait(2.0f); // Pause for a second.
    }
}

int myFunc(int x, int y) { // Function definition. Often in separate files!
    int z = (x + y)/myFactor;
    return z; // Explicit return is required in C/C++. 
}