/*
    Project: FunctionPointer
    File: main.cpp
    Modified by: Dr. C. S. Tritt
    Last revised: 11/5/17 (v. 1.0)

    Based on Horton Program 9.1 Pointing to functions.
*/
#include "mbed.h"

// Function definitions (a.k.a., prototypes).
int sum(int, int);
int product(int, int);
int difference(int, int);

int main(void)
{
    int (*pfun)(int, int); // Local function pointer declaration.
    int a = 10;  // Initial value for a.
    int b = 5;  // Initial value for b.

    pfun = sum; // pfun now points to function sum().
    int result = pfun(a, b); // Call sum() through pointer.
    printf("pfun = sum result = %d\n", result);

    pfun = product; // pfun now points to function product().
    result = pfun(a, b); // Call product() through pointer.
    printf("pfun = product result = %d\n", result);

    pfun = difference; // pfun now points to function difference().
    result = pfun(a, b); // Call difference() through pointer.
    printf("pfun = difference result = %2d\n", result);

    while (true) wait(3600.0f); // Wait forever, over and over.
}

// Function declarations...
int sum(int x, int y)
{
    return x + y;
}

int product(int x, int y)
{
    return x * y;
}

int difference(int x, int y)
{
    return x - y;
}