/*
Project: FunctionExample
File: main.cpp

 This simple program demonstrates that C passes arguments by value.
 See http://www.csie.ntu.edu.tw/~r92094/c++/VT100.html for escape sequences.
 
 Written by: Dr. C. S. Tritt; Last revised 10/3/17 (v. 1.0)
*/
#include "mbed.h"

int myFunc(int x, int y); // Function declaration required.

int main() {
    while(true) {
        const char ASCII_ESC=27; // Optional define escape for escape sequence.
        printf( "%c[2J", ASCII_ESC ); // Optional VT100 clear screen escape seq.
        printf("In function demo main...\n");        
        int a = 5; // Create and initialize a.
        printf("a = %d\n", a); // Display a.
        int b = 6; // Create and initialize b.
        printf("b = %d\n", b); // Display b.
        printf("About to call my function.\n");
        int c = myFunc(a, b); // Call my function.
        printf("Function has returned.\n");
        printf("a = %d\n", a); // Redisplay a.
        printf("b = %d\n", b); // Redisplay b.               
        printf("c = %d\n", c); // Display b.
        wait(2.0f); // Pause for a second.
    }
}

int myFunc(int x, int y) { // Function definition. Often in seperate files!
    int z = x + y;
    // Changing parameter values here won't change argument values in main!
    x = 50;
    printf("x = %d\n", x); // Generally don't put I/O in regular functions.
    y = 100;
    printf("y = %d\n", y); // Generally don't put I/O in regular functions.
    return z; // Explicit return is required in C/C++. 
}    