/*
  Project: ForLoopIteration
  File: main.cpp
 
 Demonstrates the use of a for() loop. Lights multiple LEDs in sequence, then
 in reverse.
 
 The circuit:
 
    Bargraph LEDs from pins 2 through 11 to ground via 330 Ohm resistors.
 
 Created 2006
 by David A. Mellis
 Modified 30 Aug 2011
 by Tom Igoe
 Modified for Nucleo / mbed 12 Aug 2017
 by Sheila Ross
 Modified by C. S. Tritt 9/21/17 (v. 1.0)
 
This example code is in the public domain.
*/
 
#include "mbed.h"
 
float delay = 0.1; // Seconds, the higher the number, the slower the rate.
 
BusOut bar_graph(D2,D3,D4,D5,D6,D7,D8,D9,D10,D11);
 
int main() {
  
    while(true) { // Keep the lights going back and forth forever.
 
        // Lighted bar will shift from 0 to 9 places.
        for(int shift = 0; shift < 10; shift++) {
            bar_graph = (1<<shift); // A 1 shifted over "shift" places.
            wait(delay); // Pause
        }

        // Now shift down from 9 to 0 places.
        for(int shift = 9; shift >= 0; shift--) {
            bar_graph = (1 << shift); // A 1 shifted over "shift" places.
            wait(delay); // Pause
        }
    }
}